/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.manager;

import com.ehhthan.happyhud.HappyHUD;
import com.ehhthan.happyhud.api.hud.HudAsset;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.file.YamlConfiguration;

public class AssetManager {
    private final Map<String, HudAsset> assets = new HashMap<String, HudAsset>();

    public void reload(HappyHUD happyHUD) {
        this.assets.clear();
        File[] fileArray = new File(happyHUD.getDataFolder(), "assets/hud").listFiles((file, string) -> string.endsWith(".yml"));
        if (fileArray != null) {
            for (File file2 : fileArray) {
                YamlConfiguration yamlConfiguration = YamlConfiguration.loadConfiguration((File)file2);
                for (String string2 : yamlConfiguration.getKeys(false)) {
                    if (!yamlConfiguration.isConfigurationSection(string2)) continue;
                    try {
                        HudAsset hudAsset = new HudAsset(yamlConfiguration.getConfigurationSection(string2));
                        this.assets.put(hudAsset.getKey(), hudAsset);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        happyHUD.getLogger().log(Level.WARNING, String.format("Could not load asset '%s': %s", string2, illegalArgumentException.getMessage()));
                    }
                }
            }
        }
    }

    public boolean has(String string) {
        return this.assets.containsKey(string.toLowerCase(Locale.ROOT));
    }

    public HudAsset get(String string) {
        return this.assets.get(string.toLowerCase(Locale.ROOT));
    }

    public Collection<HudAsset> getAssets() {
        return this.assets.values();
    }
}

