/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.happyhud.manager;

import com.ehhthan.happyhud.api.hud.HudAsset;
import com.ehhthan.happyhud.api.hud.HudLineConfig;
import com.ehhthan.happyhud.api.hud.condition.HudCondition;
import com.ehhthan.happyhud.api.hud.condition.type.EffectCondition;
import com.ehhthan.happyhud.api.hud.condition.type.GamemodeCondition;
import com.ehhthan.happyhud.api.hud.condition.type.PlaceholderCondition;
import com.ehhthan.happyhud.api.hud.condition.type.ProgressCondition;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConditionManager {
    private final Map<String, BiFunction<HudLineConfig, HudAsset, HudCondition>> conditions = new HashMap<String, BiFunction<HudLineConfig, HudAsset, HudCondition>>();

    public ConditionManager() {
        this.addCondition("effect", (hudLineConfig, hudAsset) -> new EffectCondition((HudLineConfig)hudLineConfig));
        this.addCondition("gamemode", (hudLineConfig, hudAsset) -> new GamemodeCondition((HudLineConfig)hudLineConfig));
        this.addCondition("progress", ProgressCondition::new);
        this.addCondition("placeholder", PlaceholderCondition::new);
    }

    public void addCondition(@NotNull String string, BiFunction<HudLineConfig, HudAsset, HudCondition> biFunction) {
        this.conditions.put(string.toLowerCase(Locale.ROOT), biFunction);
    }

    public boolean isCondition(@NotNull String string) {
        return this.conditions.containsKey(string.toLowerCase(Locale.ROOT));
    }

    public HudCondition getCondition(String string, @Nullable HudAsset hudAsset) {
        HudLineConfig hudLineConfig = HudLineConfig.of(string);
        if (this.isCondition(hudLineConfig.getKey())) {
            return this.conditions.get(hudLineConfig.getKey()).apply(hudLineConfig, hudAsset);
        }
        throw new IllegalArgumentException("Condition does not exist.");
    }
}

