/*
 * Decompiled with CFR 0.152.
 */
package com.ehhthan.libraries.kyori.adventure.pointer;

import com.ehhthan.libraries.kyori.adventure.pointer.Pointer;
import com.ehhthan.libraries.kyori.adventure.pointer.Pointers;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PointersImpl
implements Pointers {
    static final Pointers EMPTY = new Pointers(){

        @Override
        @NotNull
        public <T> Optional<T> get(@NotNull Pointer<T> pointer) {
            return Optional.empty();
        }

        @Override
        public <T> boolean supports(@NotNull Pointer<T> pointer) {
            return false;
        }

        @Override
        public @NotNull Pointers.Builder toBuilder() {
            return new BuilderImpl();
        }

        public String toString() {
            return "EmptyPointers";
        }
    };
    private final Map<Pointer<?>, Supplier<?>> pointers;

    PointersImpl(@NotNull BuilderImpl builderImpl) {
        this.pointers = new HashMap(builderImpl.pointers);
    }

    @Override
    @NotNull
    public <T> Optional<T> get(@NotNull Pointer<T> pointer) {
        Objects.requireNonNull(pointer, "pointer");
        Supplier<?> supplier = this.pointers.get(pointer);
        if (supplier == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(supplier.get());
    }

    @Override
    public <T> boolean supports(@NotNull Pointer<T> pointer) {
        Objects.requireNonNull(pointer, "pointer");
        return this.pointers.containsKey(pointer);
    }

    @Override
    public @NotNull Pointers.Builder toBuilder() {
        return new BuilderImpl(this);
    }

    static final class BuilderImpl
    implements Pointers.Builder {
        private final Map<Pointer<?>, Supplier<?>> pointers;

        BuilderImpl() {
            this.pointers = new HashMap();
        }

        BuilderImpl(@NotNull PointersImpl pointersImpl) {
            this.pointers = new HashMap(pointersImpl.pointers);
        }

        @Override
        @NotNull
        public <T> Pointers.Builder withDynamic(@NotNull Pointer<T> pointer, @NotNull Supplier<@Nullable T> supplier) {
            this.pointers.put(Objects.requireNonNull(pointer, "pointer"), Objects.requireNonNull(supplier, "value"));
            return this;
        }

        @Override
        @NotNull
        public Pointers build() {
            return new PointersImpl(this);
        }
    }
}

