/*
 * Decompiled with CFR 0.152.
 */
package Handlers;

import HologramAPI.PerkHologram;
import Perks.PerkType;
import Zombies.Main;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;

public class PerkHandler
implements Listener {
    private Map<String, Map<PerkType, Integer>> activePerks = new HashMap<String, Map<PerkType, Integer>>();
    private Map<String, List<Integer>> perkSlots = new HashMap<String, List<Integer>>();

    public boolean hasPerk(Player player, int n) {
        if (!this.activePerks.containsKey(player.getUniqueId().toString())) {
            return false;
        }
        return this.activePerks.get(player.getUniqueId().toString()).containsValue(n);
    }

    public boolean hasPerk(Player player, PerkType perkType) {
        if (!this.activePerks.containsKey(player.getUniqueId().toString())) {
            return false;
        }
        return this.activePerks.get(player.getUniqueId().toString()).containsKey((Object)perkType);
    }

    public void addActivePerkSlot(Player player, PerkType perkType, int n) {
        Map<PerkType, Integer> map = new HashMap<PerkType, Integer>();
        if (this.activePerks.containsKey(player.getUniqueId().toString())) {
            map = this.activePerks.get(player.getUniqueId().toString());
        }
        map.put(perkType, n);
        this.activePerks.put(player.getUniqueId().toString(), map);
    }

    public void clearPerks(Player player) {
        if (this.activePerks.containsKey(player.getUniqueId().toString())) {
            if (Main.getInstance().getConfiguration().getGameArena(player) != null) {
                for (PerkHologram perkHologram : Main.getInstance().getConfiguration().getGameArena(player).getPerkHolograms(player)) {
                    perkHologram.setUnlocked(false);
                }
            }
            this.activePerks.remove(player.getUniqueId().toString());
        }
    }

    public void addPerkSlot(Player player, int n) {
        List<Integer> list = new ArrayList<Integer>();
        if (this.perkSlots.containsKey(player.getUniqueId().toString())) {
            list = this.perkSlots.get(player.getUniqueId().toString());
        }
        list.add(n);
        this.perkSlots.put(player.getUniqueId().toString(), list);
    }

    public List<Integer> getPerkSlots(Player player) {
        List<Integer> list = new ArrayList<Integer>();
        if (this.perkSlots.containsKey(player.getUniqueId().toString())) {
            list = this.perkSlots.get(player.getUniqueId().toString());
        }
        return list;
    }

    public boolean isPerkSlot(Player player) {
        int n = player.getInventory().getHeldItemSlot();
        return this.perkSlots.containsKey(player.getUniqueId().toString()) && this.perkSlots.get(player.getUniqueId().toString()).contains(n);
    }

    public void unloadPerk(Player player, PerkType perkType) {
        if (perkType == null) {
            return;
        }
        if (this.activePerks.containsKey(player.getUniqueId().toString()) && this.activePerks.get(player.getUniqueId().toString()).containsKey((Object)perkType)) {
            this.activePerks.get(player.getUniqueId().toString()).remove((Object)perkType);
        }
    }
}

