/*
 * Decompiled with CFR 0.152.
 */
package Handlers;

import ActionBarAPI.ActionBar;
import ParticleAPI.EnumParticle;
import ParticleAPI.Particle;
import Perks.PerkType;
import Powerups.PowerupType;
import Utils.LocationUtils;
import Weapons.Weapon;
import Weapons.WeaponAmmo;
import Weapons.WeaponBlocks;
import Weapons.WeaponCooldown;
import Weapons.WeaponFireRate;
import Weapons.WeaponReload;
import Zombies.GameArena;
import Zombies.Main;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Explosive;
import org.bukkit.entity.Fireball;
import org.bukkit.entity.Guardian;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class WeaponHandler
implements Listener {
    private final Map<String, Map<String, WeaponReload>> reloadingWeapon = new HashMap<String, Map<String, WeaponReload>>();
    private final Map<String, Map<String, WeaponCooldown>> cooldownWeapon = new HashMap<String, Map<String, WeaponCooldown>>();
    private final Map<String, Map<String, WeaponFireRate>> fireRateCooldown = new HashMap<String, Map<String, WeaponFireRate>>();
    private final Map<String, Map<String, WeaponAmmo>> weaponAmmo = new HashMap<String, Map<String, WeaponAmmo>>();
    private final Map<String, List<Integer>> weaponSlots = new HashMap<String, List<Integer>>();
    private static int versionId = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].replace(".", "#").split("#")[1]);

    public WeaponHandler() {
        new BukkitRunnable(){
            final ActionBar actionBar = new ActionBar();

            public void run() {
                ArrayList arrayList = new ArrayList(WeaponHandler.this.cooldownWeapon.keySet());
                for (String string : arrayList) {
                    Player player = Bukkit.getPlayer((UUID)UUID.fromString(string));
                    Map map = (Map)WeaponHandler.this.cooldownWeapon.get(string);
                    ArrayList arrayList2 = new ArrayList(map.keySet());
                    for (String string2 : arrayList2) {
                        WeaponCooldown weaponCooldown = (WeaponCooldown)map.get(string2);
                        ItemStack itemStack = player.getInventory().getItem(weaponCooldown.getWeaponSlot());
                        if (weaponCooldown.getSavedItemStack().equals((Object)itemStack)) {
                            if (System.currentTimeMillis() >= weaponCooldown.getTime()) {
                                map.remove(string2);
                                WeaponHandler.this.cooldownWeapon.put(string, map);
                            }
                            weaponCooldown.setSavedItemStack(itemStack);
                            player.getInventory().setItem(weaponCooldown.getWeaponSlot(), itemStack);
                            this.actionBar.setMessage(Main.getInstance().getConfiguration().getMessage("WeaponCooldownInformation"));
                            this.actionBar.send(player);
                            continue;
                        }
                        map.remove(string2);
                        WeaponHandler.this.cooldownWeapon.put(string, map);
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 0L, 0L);
        new BukkitRunnable(){
            final ActionBar actionBar = new ActionBar();

            public void run() {
                ArrayList arrayList = new ArrayList(WeaponHandler.this.reloadingWeapon.keySet());
                for (String string : arrayList) {
                    Player player = Bukkit.getPlayer((UUID)UUID.fromString(string));
                    Map map = (Map)WeaponHandler.this.reloadingWeapon.get(string);
                    ArrayList arrayList2 = new ArrayList(map.keySet());
                    for (String string2 : arrayList2) {
                        WeaponReload weaponReload = (WeaponReload)map.get(string2);
                        Weapon weapon = weaponReload.getWeapon();
                        int n = weaponReload.getDurability();
                        ItemStack itemStack = player.getInventory().getItem(weaponReload.getWeaponSlot());
                        if (weaponReload.getSavedItemStack().equals((Object)itemStack)) {
                            int n2 = itemStack.getDurability() - n;
                            if (n2 < 0) {
                                n2 = 0;
                            }
                            if (System.currentTimeMillis() >= weaponReload.getTime()) {
                                map.remove(string2);
                                WeaponHandler.this.reloadingWeapon.put(string, map);
                                if (weapon.isUltimate()) {
                                    itemStack.setAmount(weapon.getUltimateClipAmmo());
                                } else {
                                    itemStack.setAmount(weapon.getClipAmmo());
                                }
                                n2 = 0;
                            }
                            itemStack.setDurability((short)n2);
                            weaponReload.setSavedItemStack(itemStack);
                            player.getInventory().setItem(weaponReload.getWeaponSlot(), itemStack);
                            this.actionBar.setMessage(Main.getInstance().getConfiguration().getMessage("WeaponReloadInformation"));
                            this.actionBar.send(player);
                            continue;
                        }
                        map.remove(string2);
                        WeaponHandler.this.reloadingWeapon.put(string, map);
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 0L, 0L);
        new BukkitRunnable(){

            public void run() {
                ArrayList arrayList = new ArrayList(WeaponHandler.this.fireRateCooldown.keySet());
                for (String string : arrayList) {
                    Player player = Bukkit.getPlayer((UUID)UUID.fromString(string));
                    Map map = (Map)WeaponHandler.this.fireRateCooldown.get(string);
                    ArrayList arrayList2 = new ArrayList(map.keySet());
                    for (String string2 : arrayList2) {
                        WeaponFireRate weaponFireRate = (WeaponFireRate)map.get(string2);
                        Weapon weapon = weaponFireRate.getWeapon();
                        ItemStack itemStack = player.getInventory().getItem(weaponFireRate.getWeaponSlot());
                        if (weaponFireRate.getItemStack().equals((Object)itemStack)) {
                            if (System.currentTimeMillis() >= weaponFireRate.getTime()) {
                                if (weaponFireRate.getWeaponSlot() == player.getInventory().getHeldItemSlot()) {
                                    player.setExp(1.0f);
                                }
                                map.remove(string2);
                                WeaponHandler.this.fireRateCooldown.put(string, map);
                                continue;
                            }
                            long l = weaponFireRate.getTime() - System.currentTimeMillis();
                            if (weaponFireRate.getWeaponSlot() != player.getInventory().getHeldItemSlot()) continue;
                            float f = 1.0f - 1.0f / ((float)weapon.getFireRate() / (float)l) / 1000.0f;
                            if (f < 0.0f) {
                                f = 0.0f;
                            }
                            player.setExp(f);
                            continue;
                        }
                        map.remove(string2);
                        WeaponHandler.this.fireRateCooldown.put(string, map);
                    }
                }
            }
        }.runTaskTimer((Plugin)Main.getInstance(), 0L, 0L);
    }

    @EventHandler
    public void damageExplosion(EntityDamageByEntityEvent entityDamageByEntityEvent) {
        if (entityDamageByEntityEvent.getDamager() instanceof Explosive && entityDamageByEntityEvent.getDamager().hasMetadata("WeaponExplosion")) {
            entityDamageByEntityEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void rocketImpact(ProjectileHitEvent projectileHitEvent) {
        ProjectileSource projectileSource = projectileHitEvent.getEntity().getShooter();
        if (projectileSource != null && projectileSource instanceof Player) {
            Player player = (Player)projectileSource;
            double d = 0.0;
            boolean bl = false;
            ArrayList<Entity> arrayList = new ArrayList<Entity>();
            for (Entity entity : this.getEntities(projectileHitEvent.getEntity().getLocation(), 2.5)) {
                if (!entity.hasMetadata("Zombies") || !projectileHitEvent.getEntity().hasMetadata("WeaponDamage")) continue;
                d = ((MetadataValue)projectileHitEvent.getEntity().getMetadata("WeaponDamage").get(0)).asDouble();
                if (Main.getInstance().getPerkHandler().hasPerk(player, PerkType.QUICK_FIRE)) {
                    d *= 1.25;
                }
                if (entity instanceof Creature) {
                    arrayList.add(entity);
                }
                bl = true;
            }
            if (bl && !arrayList.isEmpty()) {
                double d2 = ((MetadataValue)((Entity)arrayList.get(0)).getMetadata("Zombies").get(0)).asDouble();
                double d3 = ((Creature)arrayList.get(0)).getMaxHealth();
                double d4 = d2 / d3;
                long l = Math.round(d4 * d);
                int n = (int)Math.max(Math.min(Integer.MAX_VALUE, l), Integer.MIN_VALUE);
                GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
                if (gameArena != null) {
                    gameArena.addGold(player, Main.getInstance().getPowerupHandler().isActive(gameArena, PowerupType.INSTA_KILL) ? gameArena.getFileConfiguration().getInt("Gold.InstaKill") : n);
                }
                for (Entity entity : arrayList) {
                    if (Main.getInstance().getPowerupHandler().isActive(gameArena, PowerupType.INSTA_KILL)) {
                        if (entity instanceof Creature) {
                            if (entity.hasMetadata("BossHealth")) {
                                ((Creature)entity).damage(d, (Entity)player);
                            } else {
                                ((Creature)entity).damage(500.0, (Entity)player);
                            }
                        }
                    } else if (entity instanceof Creature) {
                        ((Creature)entity).damage(d, (Entity)player);
                    }
                    entity.setVelocity(entity.getVelocity().setY(0));
                }
            }
        }
    }

    @EventHandler
    public void switchWeapons(PlayerItemHeldEvent playerItemHeldEvent) {
        Player player = playerItemHeldEvent.getPlayer();
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return;
        }
        if (Main.getInstance().getConfiguration().getGameArena(player).hasPlayer(player)) {
            int n = playerItemHeldEvent.getNewSlot();
            ItemStack itemStack = player.getInventory().getItem(n);
            if (itemStack != null) {
                Weapon weapon = Weapon.getWeapon(itemStack);
                if (weapon != null) {
                    int n2 = this.getWeaponAmmo(player, weapon);
                    player.setLevel(n2);
                    if (!this.isFireRateWeaponSlot(player, weapon)) {
                        if (this.isOutOfAmmo(player, weapon)) {
                            player.setExp(0.0f);
                        } else {
                            player.setExp(1.0f);
                        }
                    }
                } else {
                    player.setExp(0.0f);
                    player.setLevel(0);
                }
            } else {
                player.setExp(0.0f);
                player.setLevel(0);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void clickWeapon(PlayerInteractEvent playerInteractEvent) {
        Weapon weapon;
        ItemStack itemStack;
        Player player = playerInteractEvent.getPlayer();
        if (playerInteractEvent.useItemInHand() == Event.Result.DENY) {
            return;
        }
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return;
        }
        if (!(Main.getInstance().getConfiguration().getGameArena(player).hasStarted() || playerInteractEvent.getAction() != Action.RIGHT_CLICK_AIR && playerInteractEvent.getAction() != Action.RIGHT_CLICK_BLOCK)) {
            itemStack = playerInteractEvent.getItem();
            if (itemStack == null) {
                return;
            }
            weapon = Main.getInstance().getConfiguration().getWeapon("PracticeGun");
            if (weapon.getItemStack().equals((Object)itemStack)) {
                this.lobbyShoot(player, weapon);
                return;
            }
        }
        if (Main.getInstance().getConfiguration().getGameArena(player).hasPlayer(player)) {
            itemStack = playerInteractEvent.getItem();
            if (itemStack == null) {
                return;
            }
            weapon = Weapon.getWeapon(itemStack);
            if (weapon == null) {
                return;
            }
            if (playerInteractEvent.getAction() == Action.RIGHT_CLICK_AIR || playerInteractEvent.getAction() == Action.RIGHT_CLICK_BLOCK) {
                if (weapon.getWeaponName().equals("ThePuncher")) {
                    return;
                }
                if (!this.isReloading(player, weapon) && !this.isFireRate(player, weapon)) {
                    if (this.isOutOfAmmo(player, weapon)) {
                        player.sendMessage(Main.getInstance().getConfiguration().getMessage("OutOfAmmo"));
                    } else {
                        this.shoot(player, itemStack, weapon);
                    }
                }
            }
            if (playerInteractEvent.getAction() == Action.LEFT_CLICK_AIR || playerInteractEvent.getAction() == Action.LEFT_CLICK_BLOCK) {
                if (weapon.getWeaponName().equals("PracticeGun")) {
                    return;
                }
                if (weapon.getWeaponName().equals("ThePuncher")) {
                    this.cooldown(player, itemStack, weapon);
                    return;
                }
                if (!this.isReloading(player, weapon)) {
                    if (this.isOutOfAmmo(player, weapon)) {
                        player.sendMessage(Main.getInstance().getConfiguration().getMessage("OutOfAmmo"));
                    } else {
                        this.reload(player, itemStack, weapon);
                    }
                }
            }
        }
    }

    private boolean isFireRateWeaponSlot(Player player, Weapon weapon) {
        if (this.fireRateCooldown.containsKey(player.getUniqueId().toString()) && this.fireRateCooldown.get(player.getUniqueId().toString()).containsKey(weapon.getWeaponName())) {
            return this.fireRateCooldown.get(player.getUniqueId().toString()).get(weapon.getWeaponName()).getWeaponSlot() == player.getInventory().getHeldItemSlot();
        }
        return false;
    }

    private boolean isFireRate(Player player, Weapon weapon) {
        if (this.fireRateCooldown.containsKey(player.getUniqueId().toString())) {
            return this.fireRateCooldown.get(player.getUniqueId().toString()).containsKey(weapon.getWeaponName());
        }
        return false;
    }

    private boolean isReloading(Player player, Weapon weapon) {
        if (this.reloadingWeapon.containsKey(player.getUniqueId().toString())) {
            return this.reloadingWeapon.get(player.getUniqueId().toString()).containsKey(weapon.getWeaponName());
        }
        return false;
    }

    public boolean isCooldown(Player player, Weapon weapon) {
        if (this.cooldownWeapon.containsKey(player.getUniqueId().toString())) {
            return this.cooldownWeapon.get(player.getUniqueId().toString()).containsKey(weapon.getWeaponName());
        }
        return false;
    }

    private boolean isOutOfAmmo(Player player, Weapon weapon) {
        return this.getWeaponAmmo(player, weapon) == 0;
    }

    public int getWeaponAmmo(Player player, Weapon weapon) {
        if (this.weaponAmmo.containsKey(player.getUniqueId().toString()) && this.weaponAmmo.get(player.getUniqueId().toString()).containsKey(weapon.getWeaponName())) {
            return this.weaponAmmo.get(player.getUniqueId().toString()).get(weapon.getWeaponName()).getAmmo();
        }
        return 0;
    }

    private void setWeaponAmmo(Player player, Weapon weapon, int n) {
        if (this.weaponAmmo.containsKey(player.getUniqueId().toString())) {
            Weapon weapon2;
            int n2 = player.getInventory().getHeldItemSlot();
            ItemStack itemStack = player.getInventory().getItem(n2);
            if (itemStack != null && itemStack.hasItemMeta() && (weapon2 = Weapon.getWeapon(itemStack)) != null && weapon.getWeaponName().equals(weapon2.getWeaponName())) {
                player.setLevel(n);
                if (!this.isFireRateWeaponSlot(player, weapon)) {
                    if (this.isOutOfAmmo(player, weapon)) {
                        player.setExp(0.0f);
                    } else {
                        player.setExp(1.0f);
                    }
                }
            }
            this.weaponAmmo.get(player.getUniqueId().toString()).get(weapon.getWeaponName()).setAmmo(n);
        }
    }

    private void lobbyShoot(Player player, Weapon weapon) {
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return;
        }
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        Particle particle = new Particle();
        player.playSound(player.getLocation(), Sound.valueOf((String)weapon.getShootSound()), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.WeaponShootSound"));
        ArrayList<Location> arrayList = new ArrayList<Location>();
        ArrayList<Location> arrayList2 = new ArrayList<Location>();
        Location location = player.getEyeLocation();
        Location location2 = location.clone().add(player.getEyeLocation().getDirection().multiply(30));
        arrayList.add(location);
        arrayList2.add(location2);
        ArrayList<Vector> arrayList3 = new ArrayList<Vector>();
        int n = 0;
        for (Location location3 : arrayList) {
            arrayList3.add(LocationUtils.getVector(location3, (Location)arrayList2.get(n)));
            ++n;
        }
        double d = 30.0;
        double d2 = 0.02;
        for (double d3 = 0.0; d3 <= d; d3 += d2) {
            int n2 = 0;
            for (Vector vector : arrayList3) {
                Location location4 = ((Location)arrayList.get(n2)).clone().add(vector.clone().multiply(d3));
                ++n2;
                if (WeaponBlocks.isBlock(gameArena, location4)) {
                    String string = weapon.getParticle();
                    if (string != null && !string.equals("null") && Main.getInstance().getConfiguration().getGameArena(player) != null) {
                        particle.sendParticle(Main.getInstance().getConfiguration().getGameArena(player).getDisplayedPlayers(), EnumParticle.valueOf(string), true, (float)location4.getX(), (float)location4.getY(), (float)location4.getZ(), 0.0f, 0.0f, 0.0f, 0.0f, 1, new int[0]);
                    }
                    List<Entity> list = this.getEntities(location4, 0.2);
                    for (Entity entity : list) {
                        if (!(entity instanceof Creature) || !entity.hasMetadata("PracticeDummy")) continue;
                        d3 = d;
                        player.playSound(player.getEyeLocation(), Sound.valueOf((String)weapon.getHitSound()), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.WeaponHitSound"));
                        entity.setVelocity(entity.getVelocity().setY(0));
                        ((Creature)entity).damage(0.0);
                        ((Creature)entity).setHealth(20.0);
                    }
                    continue;
                }
                d3 = d;
            }
        }
    }

    private boolean shoot(Player player, ItemStack itemStack, Weapon weapon) {
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return false;
        }
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        if (Main.getInstance().getConfiguration().getGameArena(player).isRevivedPlayer(player)) {
            return false;
        }
        if (itemStack.getAmount() >= 1) {
            if (weapon.getClipAmmo() > 0) {
                int n = this.getWeaponAmmo(player, weapon);
                this.setWeaponAmmo(player, weapon, --n);
            }
            if (itemStack.getAmount() == 1 && weapon.getClipAmmo() > 0 && !this.isOutOfAmmo(player, weapon)) {
                this.reload(player, itemStack, weapon);
            }
            ItemStack itemStack2 = this.removeShot(itemStack);
            player.getInventory().setItem(player.getInventory().getHeldItemSlot(), itemStack2);
            Particle particle = new Particle();
            player.playSound(player.getLocation(), Sound.valueOf((String)weapon.getShootSound()), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.WeaponShootSound"));
            boolean bl = weapon.getWeaponName().equals(Main.getInstance().getConfiguration().getWeapon("RocketLauncher").getWeaponName());
            if (bl) {
                Fireball fireball = (Fireball)player.launchProjectile(Fireball.class);
                if (weapon.isUltimate()) {
                    fireball.setMetadata("WeaponDamage", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)weapon.getUltimateDamage()));
                } else {
                    fireball.setMetadata("WeaponDamage", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)weapon.getDamage()));
                }
                fireball.setMetadata("WeaponExplosion", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)""));
                GameArena gameArena2 = Main.getInstance().getConfiguration().getGameArena(player);
                if (gameArena2 != null) {
                    fireball.setMetadata("Arena", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)gameArena2.getName()));
                }
                fireball.setBounce(false);
                fireball.setIsIncendiary(false);
                fireball.setYield(2.0f);
                Vector vector = player.getEyeLocation().getDirection();
                fireball.setDirection(new Vector(vector.getX(), vector.getY(), vector.getZ()));
            } else {
                ArrayList<Location> arrayList = new ArrayList<Location>();
                ArrayList<Location> arrayList2 = new ArrayList<Location>();
                boolean bl2 = weapon.getWeaponName().equals(Main.getInstance().getConfiguration().getWeapon("Shotgun").getWeaponName());
                boolean bl3 = weapon.getWeaponName().equals(Main.getInstance().getConfiguration().getWeapon("ElderGun").getWeaponName());
                boolean bl4 = weapon.getWeaponName().equals(Main.getInstance().getConfiguration().getWeapon("BlowDart").getWeaponName());
                boolean bl5 = weapon.getWeaponName().equals(Main.getInstance().getConfiguration().getWeapon("Sniper").getWeaponName());
                if (bl2) {
                    for (int i = 1; i <= Main.getInstance().getConfiguration().getWeapon("Shotgun").getBullets(); ++i) {
                        double d = ThreadLocalRandom.current().nextDouble(-0.25, 0.25);
                        double d2 = ThreadLocalRandom.current().nextDouble(-0.25, 0.25);
                        double d3 = ThreadLocalRandom.current().nextDouble(-0.25, 0.25);
                        arrayList.add(player.getEyeLocation());
                        arrayList2.add(player.getEyeLocation().clone().add(player.getEyeLocation().clone().getDirection().add(new Vector(d, d2, d3)).multiply(30)));
                    }
                } else {
                    Location location = player.getEyeLocation();
                    Location location2 = location.clone().add(player.getEyeLocation().getDirection().multiply(30));
                    arrayList.add(location);
                    arrayList2.add(location2);
                }
                ArrayList<Vector> arrayList3 = new ArrayList<Vector>();
                int n = 0;
                for (Location location : arrayList) {
                    arrayList3.add(LocationUtils.getVector(location, (Location)arrayList2.get(n)));
                    ++n;
                }
                double d = 30.0;
                double d4 = 0.02;
                int n2 = arrayList3.size();
                HashMap<Entity, Double> hashMap = new HashMap<Entity, Double>();
                for (double d5 = 0.0; d5 <= d; d5 += d4) {
                    int n3 = 0;
                    for (Vector vector : arrayList3) {
                        Location location = ((Location)arrayList.get(n3)).clone().add(vector.clone().multiply(d5));
                        ++n3;
                        if (WeaponBlocks.isBlock(gameArena, location)) {
                            String string = weapon.getParticle();
                            if (string != null && !string.equals("null") && Main.getInstance().getConfiguration().getGameArena(player) != null) {
                                particle.sendParticle(Main.getInstance().getConfiguration().getGameArena(player).getDisplayedPlayers(), EnumParticle.valueOf(string), true, (float)location.getX(), (float)location.getY(), (float)location.getZ(), 0.0f, 0.0f, 0.0f, 0.0f, 1, new int[0]);
                            }
                            List<Entity> list = this.getEntities(location, bl2);
                            boolean bl6 = false;
                            for (Entity entity : list) {
                                double d6;
                                double d7;
                                if (!(!bl6 && !bl2 || !bl6 && bl4 || bl3 || !bl6 && bl2) && !bl5 || !(entity instanceof Creature) || !entity.hasMetadata("Zombies")) continue;
                                player.playSound(player.getEyeLocation(), Sound.valueOf((String)weapon.getHitSound()), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.WeaponHitSound"));
                                if (bl3) {
                                    final Guardian guardian = (Guardian)location.getWorld().spawn(player.getLocation(), Guardian.class);
                                    guardian.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, 100, 10, true, false));
                                    player.setPassenger((Entity)guardian);
                                    ((Creature)entity).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 40, 10, true, false));
                                    final ArmorStand armorStand = (ArmorStand)guardian.getWorld().spawn(entity.getLocation(), ArmorStand.class);
                                    armorStand.setVisible(false);
                                    armorStand.setMarker(true);
                                    guardian.setTarget((LivingEntity)armorStand);
                                    new BukkitRunnable(){

                                        public void run() {
                                            armorStand.remove();
                                            guardian.remove();
                                        }
                                    }.runTaskLater((Plugin)Main.getInstance(), 30L);
                                }
                                if (bl4) {
                                    ((Creature)entity).addPotionEffect(new PotionEffect(PotionEffectType.WITHER, 100, 0, true, false));
                                    ((Creature)entity).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 100, 1, true, false));
                                }
                                double d8 = d7 = weapon.isUltimate() ? weapon.getUltimateDamage() : weapon.getDamage();
                                if (Main.getInstance().getPerkHandler().hasPerk(player, PerkType.QUICK_FIRE)) {
                                    d7 *= 1.25;
                                }
                                if (bl5 && entity.getLocation().distance(player.getLocation()) < d7 - 5.0) {
                                    d7 = entity.getLocation().distance(player.getLocation());
                                    if (Main.getInstance().getPerkHandler().hasPerk(player, PerkType.QUICK_FIRE)) {
                                        d7 *= 1.25;
                                    }
                                }
                                double d9 = ((MetadataValue)entity.getMetadata("Zombies").get(0)).asDouble();
                                double d10 = ((Creature)entity).getMaxHealth();
                                double d11 = d9 / d10;
                                long l = Math.round(d11 * (Main.getInstance().getPowerupHandler().isActive(Main.getInstance().getConfiguration().getGameArena(player), PowerupType.INSTA_KILL) ? d7 : (bl5 ? d7 / 2.0 : d7)));
                                int n4 = (int)Math.max(Math.min(Integer.MAX_VALUE, l), Integer.MIN_VALUE);
                                if (Main.getInstance().getConfiguration().getGameArena(player) != null) {
                                    if (bl2 && !Main.getInstance().getPowerupHandler().isActive(Main.getInstance().getConfiguration().getGameArena(player), PowerupType.INSTA_KILL)) {
                                        Main.getInstance().getConfiguration().getGameArena(player).addGold(player, Main.getInstance().getPowerupHandler().isActive(Main.getInstance().getConfiguration().getGameArena(player), PowerupType.INSTA_KILL) ? Main.getInstance().getConfiguration().getGameArena(player).getFileConfiguration().getInt("Gold.InstaKill") : n4);
                                    } else if (!bl2) {
                                        Main.getInstance().getConfiguration().getGameArena(player).addGold(player, Main.getInstance().getPowerupHandler().isActive(Main.getInstance().getConfiguration().getGameArena(player), PowerupType.INSTA_KILL) ? Main.getInstance().getConfiguration().getGameArena(player).getFileConfiguration().getInt("Gold.InstaKill") : n4);
                                    }
                                }
                                if (Main.getInstance().getPerkHandler().hasPerk(player, PerkType.FLAME_BULLETS)) {
                                    entity.setFireTicks(30);
                                }
                                if (Main.getInstance().getPerkHandler().hasPerk(player, PerkType.FROZEN_BULLETS)) {
                                    ((Creature)entity).addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 100, 2, true, false));
                                }
                                if (weapon.getWeaponName().equals(Main.getInstance().getConfiguration().getWeapon("ZombieZapper").getWeaponName())) {
                                    List<Entity> list2 = this.getEntities(location, 3.5);
                                    for (Entity entity2 : list2) {
                                        double d12;
                                        if (!(entity2 instanceof Creature) || entity2.equals(entity)) continue;
                                        entity2.getWorld().strikeLightning(entity2.getLocation());
                                        if (weapon.isUltimate()) {
                                            d12 = 0.0;
                                            if (hashMap.containsKey(entity2)) {
                                                d12 = (Double)hashMap.get(entity2);
                                            }
                                            hashMap.put(entity2, d12 += weapon.getUltimateDamage() / 3.0);
                                            continue;
                                        }
                                        d12 = 0.0;
                                        if (hashMap.containsKey(entity2)) {
                                            d12 = (Double)hashMap.get(entity2);
                                        }
                                        hashMap.put(entity2, d12 += weapon.getDamage() / 3.0);
                                    }
                                }
                                if (weapon.getWeaponName().equals(Main.getInstance().getConfiguration().getWeapon("Flamethrower").getWeaponName()) && !entity.hasMetadata("FireResistant")) {
                                    entity.setFireTicks(60);
                                }
                                if (weapon.getWeaponName().equals(Main.getInstance().getConfiguration().getWeapon("ZombieSoaker").getWeaponName()) && entity.hasMetadata("FireResistant")) {
                                    if (weapon.isUltimate()) {
                                        double d13 = 0.0;
                                        if (hashMap.containsKey(entity)) {
                                            d13 = (Double)hashMap.get(entity);
                                        }
                                        hashMap.put(entity, d13 += weapon.getUltimateDamage() / 2.0);
                                    } else {
                                        double d14 = 0.0;
                                        if (hashMap.containsKey(entity)) {
                                            d14 = (Double)hashMap.get(entity);
                                        }
                                        hashMap.put(entity, d14 += weapon.getDamage() / 2.0);
                                    }
                                }
                                if (Main.getInstance().getPowerupHandler().isActive(Main.getInstance().getConfiguration().getGameArena(player), PowerupType.INSTA_KILL)) {
                                    d6 = 0.0;
                                    if (hashMap.containsKey(entity)) {
                                        d6 = (Double)hashMap.get(entity);
                                    }
                                    d6 = !entity.hasMetadata("BossHealth") ? (d6 += 500.0) : (d6 += d7);
                                    hashMap.put(entity, d6);
                                } else {
                                    d6 = 0.0;
                                    if (hashMap.containsKey(entity)) {
                                        d6 = (Double)hashMap.get(entity);
                                    }
                                    hashMap.put(entity, d6 += d7);
                                }
                                entity.setVelocity(entity.getVelocity().setY(0));
                                bl6 = true;
                            }
                            if (!bl6 || --n2 > 0) continue;
                            d5 = d;
                            continue;
                        }
                        d5 = d;
                    }
                }
                Object object = hashMap.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry entry = object.next();
                    Entity entity = (Entity)entry.getKey();
                    Double d15 = (Double)entry.getValue();
                    if (!(entity instanceof Creature)) continue;
                    ((Creature)entity).damage(d15.doubleValue(), (Entity)player);
                }
                if (!hashMap.isEmpty() && bl2 && Main.getInstance().getPowerupHandler().isActive(Main.getInstance().getConfiguration().getGameArena(player), PowerupType.INSTA_KILL) && (object = Main.getInstance().getConfiguration().getGameArena(player)) != null) {
                    ((GameArena)object).addGold(player, Main.getInstance().getConfiguration().getGameArena(player).getFileConfiguration().getInt("Gold.InstaKill"));
                }
            }
            if (!this.isOutOfAmmo(player, weapon)) {
                this.loadFireRate(player, itemStack, weapon);
            } else {
                player.setExp(0.0f);
            }
            return true;
        }
        return false;
    }

    private List<Entity> getEntities(Location location, boolean bl) {
        if (versionId <= 12) {
            double d = bl ? 1.0 : 0.2;
            ArrayList<Entity> arrayList = new ArrayList<Entity>();
            arrayList.addAll(location.getWorld().getNearbyEntities(location, d, d, d));
            return arrayList;
        }
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        double d = bl ? 1.0 : 0.2;
        for (Entity entity : location.getWorld().getLivingEntities()) {
            if (!(entity instanceof Creature) || !(entity.getBoundingBox().getCenter().toLocation(entity.getWorld()).distance(location) <= d * 2.0) && !entity.getBoundingBox().contains(location.getX(), location.getY(), location.getZ())) continue;
            arrayList.add(entity);
        }
        return arrayList;
    }

    private List<Entity> getEntities(Location location, double d) {
        if (versionId <= 12) {
            ArrayList<Entity> arrayList = new ArrayList<Entity>();
            arrayList.addAll(location.getWorld().getNearbyEntities(location, d, d, d));
            return arrayList;
        }
        ArrayList<Entity> arrayList = new ArrayList<Entity>();
        for (Entity entity : location.getWorld().getLivingEntities()) {
            if (!(entity instanceof Creature) || !(entity.getBoundingBox().getCenter().toLocation(entity.getWorld()).distance(location) <= d * 2.0) && !entity.getBoundingBox().contains(location.getX(), location.getY(), location.getZ())) continue;
            arrayList.add(entity);
        }
        return arrayList;
    }

    private boolean cooldown(Player player, ItemStack itemStack, Weapon weapon) {
        if (!this.isCooldown(player, weapon)) {
            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("WeaponCooldown")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.WeaponCooldownSound"));
            Map<Object, Object> map = new HashMap();
            if (this.cooldownWeapon.containsKey(player.getUniqueId().toString())) {
                map = this.cooldownWeapon.get(player.getUniqueId().toString());
            }
            WeaponCooldown weaponCooldown = new WeaponCooldown();
            weaponCooldown.setPlayer(player);
            weaponCooldown.setWeapon(weapon);
            weaponCooldown.setWeaponSlot(player.getInventory().getHeldItemSlot());
            weaponCooldown.setItemStack(itemStack);
            weaponCooldown.setTime(System.currentTimeMillis() + Math.round(1000.0 * (weapon.isUltimate() ? weapon.getUltimateCooldown() : weapon.getCooldown())));
            map.put(weapon.getWeaponName(), weaponCooldown);
            this.cooldownWeapon.put(player.getUniqueId().toString(), map);
            return true;
        }
        return false;
    }

    private boolean reload(Player player, ItemStack itemStack, Weapon weapon) {
        if (itemStack.getAmount() < (weapon.isUltimate() ? weapon.getUltimateClipAmmo() : weapon.getClipAmmo()) && !this.isReloading(player, weapon)) {
            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("WeaponReload")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.WeaponReloadSound"));
            Map<Object, Object> map = new HashMap();
            if (this.reloadingWeapon.containsKey(player.getUniqueId().toString())) {
                map = this.reloadingWeapon.get(player.getUniqueId().toString());
            }
            WeaponReload weaponReload = new WeaponReload();
            weaponReload.setPlayer(player);
            weaponReload.setWeapon(weapon);
            weaponReload.setWeaponSlot(player.getInventory().getHeldItemSlot());
            weaponReload.setDurability(Math.round((float)itemStack.getType().getMaxDurability() / (10.0f * (float)(weapon.isUltimate() ? weapon.getUltimateReload() : weapon.getReload()) * 2.0f)));
            weaponReload.setItemStack(itemStack);
            weaponReload.setTime(System.currentTimeMillis() + Math.round(1000.0 * (weapon.isUltimate() ? weapon.getUltimateReload() : weapon.getReload())));
            map.put(weapon.getWeaponName(), weaponReload);
            this.reloadingWeapon.put(player.getUniqueId().toString(), map);
            return true;
        }
        return false;
    }

    private boolean loadFireRate(Player player, ItemStack itemStack, Weapon weapon) {
        if (!this.isFireRate(player, weapon)) {
            Map<Object, Object> map = new HashMap();
            if (this.fireRateCooldown.containsKey(player.getUniqueId().toString())) {
                map = this.fireRateCooldown.get(player.getUniqueId().toString());
            }
            WeaponFireRate weaponFireRate = new WeaponFireRate();
            weaponFireRate.setPlayer(player);
            weaponFireRate.setWeapon(weapon);
            weaponFireRate.setWeaponSlot(player.getInventory().getHeldItemSlot());
            weaponFireRate.setItemStack(itemStack);
            weaponFireRate.setTime(System.currentTimeMillis() + Math.round(1000.0 * (weapon.isUltimate() ? weapon.getUltimateFireRate() : weapon.getFireRate())));
            map.put(weapon.getWeaponName(), weaponFireRate);
            this.fireRateCooldown.put(player.getUniqueId().toString(), map);
            return true;
        }
        return false;
    }

    private ItemStack removeShot(ItemStack itemStack) {
        if (itemStack.getAmount() > 1) {
            itemStack.setAmount(itemStack.getAmount() - 1);
            return itemStack;
        }
        return itemStack;
    }

    public void loadWeaponAmmo(Player player, Weapon weapon) {
        if (weapon.getClipAmmo() > 0) {
            Map<String, WeaponAmmo> map = new HashMap<String, WeaponAmmo>();
            if (this.weaponAmmo.containsKey(player.getUniqueId().toString())) {
                map = this.weaponAmmo.get(player.getUniqueId().toString());
            }
            map.put(weapon.getWeaponName(), new WeaponAmmo().setAmmo(weapon.isUltimate() ? weapon.getUltimateAmmo() : weapon.getAmmo()));
            this.weaponAmmo.put(player.getUniqueId().toString(), map);
            this.setWeaponAmmo(player, weapon, weapon.isUltimate() ? weapon.getUltimateAmmo() : weapon.getAmmo());
        }
    }

    public void unloadWeapon(Player player, int n, Weapon weapon) {
        if (weapon == null) {
            return;
        }
        if (this.reloadingWeapon.containsKey(player.getUniqueId().toString())) {
            this.reloadingWeapon.get(player.getUniqueId().toString()).remove(weapon.getWeaponName());
        }
        if (this.fireRateCooldown.containsKey(player.getUniqueId().toString())) {
            this.fireRateCooldown.get(player.getUniqueId().toString()).remove(weapon.getWeaponName());
        }
        ItemStack itemStack = player.getInventory().getItem(n);
        Weapon weapon2 = Weapon.getWeapon(itemStack);
        assert (weapon2 != null);
        if (weapon.getWeaponName().equals(weapon2.getWeaponName())) {
            player.setLevel(0);
            player.setExp(1.0f);
        }
    }

    public Map<Integer, Weapon> getWeapons(Player player) {
        HashMap<Integer, Weapon> hashMap = new HashMap<Integer, Weapon>();
        for (int n : this.getWeaponSlots(player)) {
            Weapon weapon = Weapon.getWeapon(player.getInventory().getItem(n));
            hashMap.put(n, weapon);
        }
        return hashMap;
    }

    public void addWeaponSlot(Player player, int n) {
        List<Integer> list = new ArrayList<Integer>();
        if (this.weaponSlots.containsKey(player.getUniqueId().toString())) {
            list = this.weaponSlots.get(player.getUniqueId().toString());
        }
        list.add(n);
        this.weaponSlots.put(player.getUniqueId().toString(), list);
    }

    public void removeWeaponSlot(Player player, int n) {
        if (this.weaponSlots.containsKey(player.getUniqueId().toString())) {
            List<Integer> list = this.weaponSlots.get(player.getUniqueId().toString());
            list.remove((Object)n);
            this.weaponSlots.put(player.getUniqueId().toString(), list);
        }
    }

    public boolean hasWeapon(Player player, Weapon weapon) {
        if (weapon == null) {
            return false;
        }
        for (Weapon weapon2 : this.getWeapons(player).values()) {
            if (weapon2 == null || !weapon2.getWeaponName().equals(weapon.getWeaponName())) continue;
            return true;
        }
        return false;
    }

    public List<Integer> getWeaponSlots(Player player) {
        List<Integer> list = new ArrayList<Integer>();
        if (this.weaponSlots.containsKey(player.getUniqueId().toString())) {
            list = this.weaponSlots.get(player.getUniqueId().toString());
        }
        return list;
    }
}

