/*
 * Decompiled with CFR 0.152.
 */
package HologramAPI;

import HologramAPI.Hologram;
import HologramAPI.WeaponHologram;
import Perks.Perk;
import Perks.PerkType;
import Utils.ItemStackUtils;
import Utils.LocationUtils;
import Weapons.Weapon;
import Zombies.Configuration;
import Zombies.GameArena;
import Zombies.Main;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class PerkHologram {
    private Hologram hologram;
    private List<Location> locations;
    private Player player;
    private boolean unlocked;
    private boolean activated;
    private String message;
    private int gold;
    private Perk perk;
    private PerkType perkType;
    private int versionId = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].replace(".", "#").split("#")[1]);

    public PerkHologram(Player player, String string) {
        this.player = player;
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return;
        }
        FileConfiguration fileConfiguration = Main.getInstance().getConfiguration().getGameArena(player).getFileConfiguration();
        this.gold = fileConfiguration.getInt("PerkShop.Position." + string + ".PerkGold");
        this.perkType = PerkType.valueOf(fileConfiguration.getString("PerkShop.Position." + string + ".PerkName"));
        String[] stringArray = fileConfiguration.getString("PerkShop.Position." + string + ".Pos1").split(":");
        String[] stringArray2 = fileConfiguration.getString("PerkShop.Position." + string + ".Pos2").split(":");
        String[] stringArray3 = fileConfiguration.getString("PerkShop.Position." + string + ".Hologram").split(":");
        Location location = new Location(Bukkit.getWorld((String)stringArray[0]), (double)Integer.valueOf(stringArray[1]).intValue(), (double)Integer.valueOf(stringArray[2]).intValue(), (double)Integer.valueOf(stringArray[3]).intValue());
        Location location2 = new Location(Bukkit.getWorld((String)stringArray2[0]), (double)Integer.valueOf(stringArray2[1]).intValue(), (double)Integer.valueOf(stringArray2[2]).intValue(), (double)Integer.valueOf(stringArray2[3]).intValue());
        Location location3 = new Location(Bukkit.getWorld((String)stringArray3[0]), Double.valueOf(stringArray3[1]).doubleValue(), Double.valueOf(stringArray3[2]).doubleValue(), Double.valueOf(stringArray3[3]).doubleValue());
        this.locations = LocationUtils.getBlocks(location, location2);
        this.hologram = new Hologram(location3);
        this.perk = new Perk().setPerkType(this.perkType).setDisplayName(Main.getInstance().getConfiguration().getFileConfiguration().getString("Perks." + this.perkType.getPath() + ".DisplayName")).setMaterial(Material.valueOf((String)Main.getInstance().getConfiguration().getFileConfiguration().getString("Perks." + this.perkType.getPath() + ".Material"))).setLores(Main.getInstance().getConfiguration().getFileConfiguration().getStringList("Perks." + this.perkType.getPath() + ".Lores"));
        this.message = Main.getInstance().getConfiguration().getMessage("Shop.Perks.HologramHeader").replace("%perkName%", ChatColor.stripColor((String)this.perk.getDisplayName()));
        this.hologram.setCleanLines(this.message, Main.getInstance().getConfiguration().getMessage("Shop.Perks.InactiveHologramFooter"));
        this.hologram.show(player);
    }

    public void restore(Player player) {
        this.hologram.show(player);
    }

    public Perk getPerk() {
        return this.perk;
    }

    public PerkType getPerkType() {
        return this.perkType;
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getGold() {
        return this.gold;
    }

    public boolean isActivated() {
        return this.activated;
    }

    public void setActivated() {
        this.activated = true;
        this.hologram.destroyFrom(this.player);
        this.hologram.setCleanLines(this.message, Main.getInstance().getConfiguration().getMessage("Shop.Perks.ActiveHologramFooter").replace("%goldValue%", String.valueOf(this.gold)));
        this.hologram.show(this.player);
    }

    public int getEmptyPerkSlot() {
        for (int n : Main.getInstance().getPerkHandler().getPerkSlots(this.player)) {
            Perk perk = Perk.getPerk(this.player.getInventory().getItem(n));
            if (perk != null) continue;
            return n;
        }
        return -1;
    }

    public void setUnlocked(boolean bl) {
        this.unlocked = bl;
        if (bl) {
            String string = Main.getInstance().getConfiguration().getMessage("Shop.Perks.Unlocked");
            this.hologram.destroyFrom(this.player);
            this.hologram.setCleanLines(this.message, string);
            this.hologram.show(this.player);
        } else {
            this.hologram.destroyFrom(this.player);
            this.hologram.setCleanLines(this.message, this.isActivated() ? Main.getInstance().getConfiguration().getMessage("Shop.Perks.ActiveHologramFooter").replace("%goldValue%", String.valueOf(this.gold)) : Main.getInstance().getConfiguration().getMessage("Shop.Perks.InactiveHologramFooter"));
            this.hologram.show(this.player);
            this.unloadPerk();
        }
    }

    public void unloadPerk() {
        if (Main.getInstance().getConfiguration().getGameArena(this.player) == null) {
            return;
        }
        if (this.getPerkType() == PerkType.EXTRA_HEALTH) {
            this.player.setMaxHealth(20.0);
        }
        if (this.getPerkType() == PerkType.EXTRA_WEAPON) {
            Weapon weapon = Weapon.getWeapon(this.player.getInventory().getItem(3));
            if (weapon != null) {
                for (WeaponHologram weaponHologram : Main.getInstance().getConfiguration().getGameArena(this.player).getWeaponHolograms(this.player)) {
                    if (weaponHologram.equals(this) || weaponHologram.getWeapon() == null || !weaponHologram.getWeapon().getWeaponName().equals(weapon.getWeaponName())) continue;
                    weaponHologram.setUnlocked(false);
                }
            }
            Main.getInstance().getWeaponHandler().unloadWeapon(this.player, 3, weapon);
            Main.getInstance().getWeaponHandler().removeWeaponSlot(this.player, 3);
            this.player.getInventory().clear(3);
        }
        if (this.getPerkType() == PerkType.SPEED && this.player.hasPotionEffect(PotionEffectType.SPEED)) {
            this.player.removePotionEffect(PotionEffectType.SPEED);
        }
        Main.getInstance().getPerkHandler().unloadPerk(this.player, this.getPerkType());
    }

    public void loadPerk() {
        if (this.getPerkType() == PerkType.EXTRA_HEALTH) {
            this.player.setMaxHealth(30.0);
        }
        if (this.getPerkType() == PerkType.EXTRA_WEAPON) {
            ArrayList<String> arrayList = new ArrayList<String>();
            GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(this.player);
            for (String string : gameArena.getFileConfiguration().getStringList("InventoryItems.GunSlot.Lores")) {
                arrayList.add(Configuration.translateTextCodes(string));
            }
            this.player.getInventory().setItem(3, ItemStackUtils.getItem(this.versionId >= 13 ? Material.LEGACY_INK_SACK : Material.getMaterial((String)"INK_SACK"), 1, 7, Configuration.translateTextCodes(gameArena.getFileConfiguration().getString("InventoryItems.GunSlot.DisplayName").replace("%id%", String.valueOf(3))), arrayList));
            Main.getInstance().getWeaponHandler().addWeaponSlot(this.player, 3);
        }
        if (this.getPerkType() == PerkType.SPEED) {
            if (this.player.hasPotionEffect(PotionEffectType.SPEED)) {
                this.player.removePotionEffect(PotionEffectType.SPEED);
            }
            this.player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 0, true, false));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean purchase(Player player) {
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return false;
        }
        if (this.isUnlocked()) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("Shop.Perks.AlreadyPurchased").replace("%perkName%", ChatColor.stripColor((String)this.perk.getDisplayName())));
            return false;
        }
        if (!this.isActivated()) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("Shop.Perks.RequiresPower"));
            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
            return false;
        }
        if (Main.getInstance().getConfiguration().getGameArena(player).getGold(player) < this.getGold()) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("NotEnoughGold"));
            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
            return false;
        }
        int n = player.getInventory().getHeldItemSlot();
        int n2 = this.getEmptyPerkSlot();
        if (n2 == -1) {
            if (Main.getInstance().getPerkHandler().getPerkSlots(player).contains(n)) {
                Perk perk;
                ItemStack itemStack = player.getInventory().getItem(n);
                if (itemStack == null || (perk = Perk.getPerk(itemStack)) == null) return true;
                this.setUnlocked(true);
                player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("ShopItemBought")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.ShopItemBought"));
                Main.getInstance().getConfiguration().getGameArena(player).removeGold(player, this.getGold());
                player.sendMessage(Main.getInstance().getConfiguration().getMessage("Shop.Perks.Purchase").replace("%perkName%", ChatColor.stripColor((String)this.perk.getDisplayName())));
                Main.getInstance().getPerkHandler().unloadPerk(player, perk.getPerkType());
                player.getInventory().setItem(n, this.perk.getItemStack());
                Main.getInstance().getPerkHandler().addActivePerkSlot(player, this.perk.getPerkType(), n2);
                this.loadPerk();
                for (PerkHologram perkHologram : Main.getInstance().getConfiguration().getGameArena(player).getPerkHolograms(player)) {
                    if (perkHologram.equals(this) || !perkHologram.getPerk().getDisplayName().equals(perk.getDisplayName())) continue;
                    perkHologram.setUnlocked(false);
                }
                return true;
            }
            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("Shop.Perks.MaxPerks"));
            return false;
        }
        this.setUnlocked(true);
        player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("ShopItemBought")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.ShopItemBought"));
        Main.getInstance().getConfiguration().getGameArena(player).removeGold(player, this.getGold());
        player.sendMessage(Main.getInstance().getConfiguration().getMessage("Shop.Perks.Purchase").replace("%perkName%", ChatColor.stripColor((String)this.perk.getDisplayName())));
        player.getInventory().setItem(n2, this.perk.getItemStack());
        Main.getInstance().getPerkHandler().addActivePerkSlot(player, this.perk.getPerkType(), n2);
        this.loadPerk();
        return true;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public Hologram getHologram() {
        return this.hologram;
    }
}

