/*
 * Decompiled with CFR 0.152.
 */
package HologramAPI;

import HologramAPI.Hologram;
import HologramAPI.PerkHologram;
import HologramAPI.TeamMachineHologram;
import HologramAPI.UltimateMachineHologram;
import TitleAPI.Title;
import Utils.ItemStackUtils;
import Utils.LocationUtils;
import Zombies.Configuration;
import Zombies.GameArena;
import Zombies.Main;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class PowerSwitchHologram {
    private Hologram hologram;
    private List<Location> locations;
    private Player player;
    private boolean unlocked;
    private String message;
    private int gold;
    private int versionId = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].replace(".", "#").split("#")[1]);

    public PowerSwitchHologram(Player player) {
        this.player = player;
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return;
        }
        FileConfiguration fileConfiguration = Main.getInstance().getConfiguration().getGameArena(player).getFileConfiguration();
        this.gold = fileConfiguration.getInt("PowerSwitch.Gold");
        String[] stringArray = fileConfiguration.getString("PowerSwitch.Pos1").split(":");
        String[] stringArray2 = fileConfiguration.getString("PowerSwitch.Pos2").split(":");
        String[] stringArray3 = fileConfiguration.getString("PowerSwitch.Hologram").split(":");
        Location location = new Location(Bukkit.getWorld((String)stringArray[0]), (double)Integer.valueOf(stringArray[1]).intValue(), (double)Integer.valueOf(stringArray[2]).intValue(), (double)Integer.valueOf(stringArray[3]).intValue());
        Location location2 = new Location(Bukkit.getWorld((String)stringArray2[0]), (double)Integer.valueOf(stringArray2[1]).intValue(), (double)Integer.valueOf(stringArray2[2]).intValue(), (double)Integer.valueOf(stringArray2[3]).intValue());
        Location location3 = new Location(Bukkit.getWorld((String)stringArray3[0]), Double.valueOf(stringArray3[1]).doubleValue(), Double.valueOf(stringArray3[2]).doubleValue(), Double.valueOf(stringArray3[3]).doubleValue());
        this.locations = LocationUtils.getBlocks(location, location2);
        this.hologram = new Hologram(location3);
        this.message = Main.getInstance().getConfiguration().getMessage("PowerSwitch.HologramHeader");
        this.hologram.setCleanLines(this.message, Main.getInstance().getConfiguration().getMessage("PowerSwitch.InactiveHologramFooter").replace("%goldValue%", String.valueOf(this.gold)));
        this.hologram.show(player);
    }

    public void restore(Player player) {
        this.hologram.show(player);
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getGold() {
        return this.gold;
    }

    public void setUnlocked() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.player == null) {
            return;
        }
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(this.player);
        if (gameArena == null) {
            return;
        }
        for (String string : gameArena.getFileConfiguration().getStringList("InventoryItems.ActivePerkSlot.Lores")) {
            arrayList.add(Configuration.translateTextCodes(string));
        }
        this.player.getInventory().setItem(6, ItemStackUtils.getItem(this.versionId >= 13 ? Material.LEGACY_INK_SACK : Material.getMaterial((String)"INK_SACK"), 1, 8, Configuration.translateTextCodes(gameArena.getFileConfiguration().getString("InventoryItems.ActivePerkSlot.DisplayName").replace("%id%", String.valueOf(1))), arrayList));
        this.player.getInventory().setItem(7, ItemStackUtils.getItem(this.versionId >= 13 ? Material.LEGACY_INK_SACK : Material.getMaterial((String)"INK_SACK"), 1, 8, Configuration.translateTextCodes(gameArena.getFileConfiguration().getString("InventoryItems.ActivePerkSlot.DisplayName").replace("%id%", String.valueOf(2))), arrayList));
        this.player.getInventory().setItem(8, ItemStackUtils.getItem(this.versionId >= 13 ? Material.LEGACY_INK_SACK : Material.getMaterial((String)"INK_SACK"), 1, 8, Configuration.translateTextCodes(gameArena.getFileConfiguration().getString("InventoryItems.ActivePerkSlot.DisplayName").replace("%id%", String.valueOf(3))), arrayList));
        this.unlocked = true;
        String string = Main.getInstance().getConfiguration().getMessage("PowerSwitch.ActiveHologramFooter");
        this.hologram.destroyFrom(this.player);
        this.hologram.setCleanLines(this.message, string);
        this.hologram.show(this.player);
        if (Main.getInstance().getConfiguration().getBoolean("PowerSwitchUnlockDoors").booleanValue()) {
            gameArena.unlockDoors();
        }
    }

    public boolean purchase(Player player) {
        GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
        if (gameArena == null) {
            return false;
        }
        if (this.isUnlocked()) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("PowerSwitch.AlreadyActivated"));
            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
            return false;
        }
        if (gameArena.getGold(player) < this.getGold()) {
            player.sendMessage(Main.getInstance().getConfiguration().getMessage("NotEnoughGold"));
            player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("NotEnoughGold")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.NotEnoughGold"));
            return false;
        }
        this.setUnlocked();
        gameArena.setPowerSwitchActivated(true);
        Title title = new Title();
        title.setFadeIn(5);
        title.setStay(20);
        title.setFadeOut(5);
        title.setTitle(Main.getInstance().getConfiguration().getMessage("PowerSwitch.Title").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()));
        title.setSubTitle(Main.getInstance().getConfiguration().getMessage("PowerSwitch.SubTitle").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()));
        title.sendTimes(gameArena.getDisplayedPlayers());
        title.sendTitle(gameArena.getDisplayedPlayers());
        title.sendSubTitle(gameArena.getDisplayedPlayers());
        player.playSound(player.getEyeLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("PowerSwitchActivated")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.PowerSwitchActivated"));
        gameArena.removeGold(player, this.getGold());
        for (PerkHologram object : gameArena.getPerkHolograms()) {
            object.setActivated();
        }
        for (UltimateMachineHologram ultimateMachineHologram : gameArena.getUltimateMachineHolograms()) {
            ultimateMachineHologram.setActivated();
        }
        for (TeamMachineHologram teamMachineHologram : gameArena.getTeamMachineHolograms()) {
            teamMachineHologram.setActivated();
        }
        for (PowerSwitchHologram powerSwitchHologram : gameArena.getPowerSwitchHolograms()) {
            if (powerSwitchHologram.equals(this)) continue;
            powerSwitchHologram.setUnlocked();
        }
        return true;
    }

    public boolean isUnlocked() {
        return this.unlocked;
    }

    public Hologram getHologram() {
        return this.hologram;
    }
}

