/*
 * Decompiled with CFR 0.152.
 */
package HologramAPI;

import HologramAPI.Hologram;
import HologramAPI.ItemHologram;
import Powerups.PowerupType;
import Utils.ItemStackUtils;
import Zombies.Main;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class PowerupHologram {
    private Hologram hologram;
    private ItemHologram itemHologram;
    private PowerupType powerupType;
    private Location location;
    private Player player;
    private long duration;
    private long expireDuration;
    private int versionId = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].replace(".", "#").split("#")[1]);

    public PowerupHologram(Player player, Location location, PowerupType powerupType) {
        this.player = player;
        this.location = location;
        this.powerupType = powerupType;
        this.itemHologram = new ItemHologram(location.clone().add(0.0, 0.73, 0.0));
        this.hologram = new Hologram(location);
        ItemStack itemStack = null;
        switch (powerupType) {
            case MAX_AMMO: {
                this.hologram.setCleanLines(Main.getInstance().getConfiguration().getMessage("Powerups.MAX_AMMO.Hologram"));
                itemStack = ItemStackUtils.getItem(Material.ARROW, 1, 0, "", new String[0]);
                break;
            }
            case DOUBLE_GOLD: {
                this.hologram.setCleanLines(Main.getInstance().getConfiguration().getMessage("Powerups.DOUBLE_GOLD.Hologram"));
                itemStack = ItemStackUtils.getItem(this.versionId >= 13 ? Material.LEGACY_DOUBLE_PLANT : Material.getMaterial((String)"DOUBLE_PLANT"), 1, 0, "", new String[0]);
                this.duration = Main.getInstance().getConfiguration().getFileConfiguration().getInt("Powerups.DOUBLE_GOLD.Duration") * 1000;
                break;
            }
            case INSTA_KILL: {
                this.hologram.setCleanLines(Main.getInstance().getConfiguration().getMessage("Powerups.INSTA_KILL.Hologram"));
                itemStack = ItemStackUtils.enchant(ItemStackUtils.getItem(Material.DIAMOND_SWORD, 1, 0, "", new String[0]), Enchantment.DAMAGE_ALL, 1);
                this.duration = Main.getInstance().getConfiguration().getFileConfiguration().getInt("Powerups.INSTA_KILL.Duration") * 1000;
                break;
            }
            case SHOPPING_SPREE: {
                this.hologram.setCleanLines(Main.getInstance().getConfiguration().getMessage("Powerups.SHOPPING_SPREE.Hologram"));
                itemStack = ItemStackUtils.enchant(ItemStackUtils.getItem(Material.CHEST, 1, 0, "", new String[0]), Enchantment.DAMAGE_ALL, 1);
                this.duration = Main.getInstance().getConfiguration().getFileConfiguration().getInt("Powerups.SHOPPING_SPREE.Duration") * 1000;
                break;
            }
            case BONUS_GOLD: {
                this.hologram.setCleanLines(Main.getInstance().getConfiguration().getMessage("Powerups.BONUS_GOLD.Hologram"));
                itemStack = ItemStackUtils.enchant(ItemStackUtils.getItem(this.versionId >= 13 ? Material.LEGACY_DOUBLE_PLANT : Material.getMaterial((String)"DOUBLE_PLANT"), 1, 0, "", new String[0]), Enchantment.DAMAGE_ALL, 1);
                this.duration = 0L;
                break;
            }
            case CARPENTER: {
                this.hologram.setCleanLines(Main.getInstance().getConfiguration().getMessage("Powerups.CARPENTER.Hologram"));
                itemStack = ItemStackUtils.enchant(ItemStackUtils.getItem(Material.DIAMOND_PICKAXE, 1, 0, "", new String[0]), Enchantment.DAMAGE_ALL, 1);
                this.duration = 0L;
            }
        }
        this.expireDuration = System.currentTimeMillis() + this.duration;
        this.itemHologram.setCleanItems(itemStack);
        this.itemHologram.show(player);
        this.hologram.show(player);
    }

    public void restore(Player player) {
        this.itemHologram.show(player);
        this.hologram.show(player);
    }

    public Player getPlayer() {
        return this.player;
    }

    public Location getLocation() {
        return this.location;
    }

    public PowerupType getPowerupType() {
        return this.powerupType;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getExpireDuration() {
        return this.expireDuration;
    }

    public ItemHologram getItemHologram() {
        return this.itemHologram;
    }

    public Hologram getHologram() {
        return this.hologram;
    }
}

