/*
 * Decompiled with CFR 0.152.
 */
package Revive;

import ActionBarAPI.ActionBar;
import Events.ArenaPlayerReviveDeathEvent;
import Events.ArenaPlayerReviveFinishEvent;
import Events.ArenaPlayerReviveStartEvent;
import Events.ArenaPlayerReviveStopEvent;
import HologramAPI.Hologram;
import TitleAPI.Title;
import Utils.Reflection;
import Zombies.Configuration;
import Zombies.GameArena;
import Zombies.Main;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class RevivePlayer {
    private static Class<?> packet;
    private static Method getHandle;
    private static Method getDataWatcher;
    private static Method getDataWatcherB;
    private static Class<?> dataWatcher;
    private static Constructor<?> constructBlockPosition;
    private static Constructor<?> constructEntityDestroyPacket;
    private static Constructor<?> constructNamedEntitySpawnPacket;
    private static Constructor<?> constructMetaPacket;
    private static Constructor<?> constructRelEntityMovePacket;
    private static boolean invoked;
    private int entityId;
    private Player player;
    private Player reviver;
    private Location location;
    private Location respawnLocation;
    private Hologram hologram;
    private double reviveTime;
    private final double defaultSneakTime;
    private double sneakTime;
    private String entityName;
    private List<String> hologramStringList;
    private boolean active;
    private ArmorStand invisibleArmorStand;
    private final DecimalFormat decimalFormat = new DecimalFormat("0.0");
    private boolean sneaking;
    private final Title title;
    private final ActionBar actionBar;
    private static final int versionId;

    public RevivePlayer() {
        if (!invoked) {
            try {
                Class<?> clazz = Reflection.getCraftClass("entity.CraftPlayer");
                Class<?> clazz2 = Reflection.getMinecraftClass("net.minecraft.world.entity.Entity");
                Class<?> clazz3 = Reflection.getMinecraftClass("net.minecraft.world.entity.player.EntityHuman");
                Class<?> clazz4 = Reflection.getMinecraftClass("net.minecraft.network.protocol.game.PacketPlayOutEntityDestroy");
                Class<?> clazz5 = Reflection.getMinecraftClass("net.minecraft.network.protocol.game.PacketPlayOutNamedEntitySpawn");
                Class<?> clazz6 = Reflection.getMinecraftClass("net.minecraft.network.protocol.game.PacketPlayOutEntityMetadata");
                Class<?> clazz7 = Reflection.getMinecraftClass("net.minecraft.network.protocol.game.PacketPlayOutEntity$PacketPlayOutRelEntityMove");
                packet = Reflection.getMinecraftClass("net.minecraft.network.protocol.Packet");
                dataWatcher = Reflection.getMinecraftClass("net.minecraft.network.syncher.DataWatcher");
                Class<?> clazz8 = Reflection.getMinecraftClass("net.minecraft.core.BlockPosition");
                constructEntityDestroyPacket = clazz4.getConstructor(int[].class);
                constructNamedEntitySpawnPacket = clazz5.getConstructor(clazz3);
                constructMetaPacket = clazz6.getConstructor(Integer.TYPE, List.class);
                constructBlockPosition = clazz8.getConstructor(Integer.TYPE, Integer.TYPE, Integer.TYPE);
                constructRelEntityMovePacket = clazz7.getConstructor(Integer.TYPE, Short.TYPE, Short.TYPE, Short.TYPE, Boolean.TYPE);
                getHandle = clazz.getDeclaredMethod("getHandle", new Class[0]);
                getDataWatcher = clazz2.getDeclaredMethod("aj", new Class[0]);
                getDataWatcherB = dataWatcher.getMethod("b", new Class[0]);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            invoked = true;
        }
        this.title = new Title();
        this.actionBar = new ActionBar();
        this.defaultSneakTime = this.sneakTime = Main.getInstance().getConfig().getDouble("Revive.SneakTime");
    }

    public Player getPlayer() {
        return this.player;
    }

    public ArmorStand getInvisibleArmorStand() {
        return this.invisibleArmorStand;
    }

    public void setSneakTime(Player player, double d) {
        if (Main.getInstance().getConfiguration().getGameArena(this.player) == null) {
            return;
        }
        if (this.active) {
            if (!this.isSneaking()) {
                this.title.setTitle(Main.getInstance().getConfiguration().getMessage("ReviveTitle"));
                this.title.setFadeIn(5);
                this.title.setStay(100);
                this.title.setFadeOut(5);
                this.title.sendTimes(Arrays.asList(this.player));
                this.title.sendTitle(Arrays.asList(this.player));
                this.setSneaking(true);
                this.reviver = player;
                Bukkit.getPluginManager().callEvent((Event)new ArenaPlayerReviveStartEvent(this.player, player, Main.getInstance().getConfiguration().getGameArena(this.player)));
            }
            this.sneakTime = d;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 1;
            for (String string : this.hologramStringList) {
                arrayList.add(Configuration.translateTextCodes(string).replace("%time%", this.decimalFormat.format(d).replace(",", ".")));
                this.hologram.changeTexts(Configuration.translateTextCodes(string).replace("%time%", this.decimalFormat.format(d).replace(",", ".")), n);
                ++n;
            }
            this.hologram.setCleanLines(arrayList);
            if (d <= 0.0) {
                this.resetStatus();
                if (!player.hasPotionEffect(PotionEffectType.SPEED)) {
                    player.addPotionEffect(new PotionEffect(PotionEffectType.SPEED, 100, 1, true, false));
                }
                Bukkit.getPluginManager().callEvent((Event)new ArenaPlayerReviveFinishEvent(this.player, player, Main.getInstance().getConfiguration().getGameArena(this.player)));
                Main.getInstance().getConfiguration().getGameArena(this.player).sendMessage(Main.getInstance().getConfiguration().getMessage("Revived").replace("%displayName%", player.getDisplayName()).replace("%playerName%", player.getName()).replace("%revivedDisplayName%", this.player.getDisplayName()));
            }
        }
    }

    public double getSneakTime() {
        return this.sneakTime;
    }

    public void setReviveTime(double d) {
        if (Main.getInstance().getConfiguration().getGameArena(this.player) == null) {
            return;
        }
        this.sneakTime = this.defaultSneakTime;
        if (this.isSneaking()) {
            this.title.sendReset(Collections.singletonList(this.player));
            this.setSneaking(false);
            Bukkit.getPluginManager().callEvent((Event)new ArenaPlayerReviveStopEvent(this.player, this.reviver, Main.getInstance().getConfiguration().getGameArena(this.player)));
            this.reviver = null;
        }
        if (this.active) {
            this.reviveTime = d;
            ArrayList<String> arrayList = new ArrayList<String>();
            int n = 1;
            this.actionBar.setMessage(Main.getInstance().getConfiguration().getMessage("ReviveActionBar").replace("%time%", this.decimalFormat.format(d).replace(",", ".")));
            this.actionBar.send(this.player);
            for (String object : this.hologramStringList) {
                arrayList.add(Configuration.translateTextCodes(object).replace("%time%", this.decimalFormat.format(d).replace(",", ".")));
                this.hologram.changeTexts(Configuration.translateTextCodes(object).replace("%time%", this.decimalFormat.format(d).replace(",", ".")), n);
                ++n;
            }
            this.hologram.setCleanLines(arrayList);
            if (d <= 0.0) {
                Object object;
                Main.getInstance().getConfiguration().getGameArena(this.player).sendMessage(Main.getInstance().getConfiguration().getMessage("ReviveDead").replace("%displayName%", this.player.getDisplayName()).replace("%playerName%", this.player.getName()).replace("%name%", this.entityName));
                this.active = false;
                this.player.teleport(this.respawnLocation);
                try {
                    object = constructEntityDestroyPacket.newInstance(new Object[]{new int[]{this.entityId}});
                    for (Player player : Main.getInstance().getConfiguration().getGameArena(this.getPlayer()).getDisplayedPlayers()) {
                        this.sendPacket(player, object);
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                this.hologram.destroy();
                object = new Title();
                ((Title)object).setFadeIn(5);
                ((Title)object).setStay(50);
                ((Title)object).setFadeOut(5);
                ((Title)object).setTitle(Main.getInstance().getConfiguration().getMessage("DeathTitle"));
                ((Title)object).setSubTitle(Main.getInstance().getConfiguration().getMessage("DeathSubTitle"));
                ((Title)object).sendTimes(Arrays.asList(this.player));
                ((Title)object).sendTitle(Arrays.asList(this.player));
                ((Title)object).sendSubTitle(Arrays.asList(this.player));
                Bukkit.getPluginManager().callEvent((Event)new ArenaPlayerReviveDeathEvent(this.player, Main.getInstance().getConfiguration().getGameArena(this.player)));
                Main.getInstance().getConfiguration().getGameArena(this.player).setDead(this.player);
                Main.getInstance().getConfiguration().getGameArena(this.player).removeRevivePlayer(this.player, false);
            }
        }
    }

    public double getReviveTime() {
        return this.reviveTime;
    }

    public RevivePlayer sendStatus(final Player player, Entity entity) {
        ArrayList<String> arrayList;
        if (entity != null) {
            this.entityName = ((MetadataValue)entity.getMetadata("ZombieName").get(0)).asString();
        }
        this.player = player;
        if (Main.getInstance().getConfiguration().getGameArena(player) == null) {
            return this;
        }
        this.respawnLocation = player.getLocation();
        this.location = this.getLocation(player, 1);
        if (this.location == null) {
            this.location = player.getLocation();
        }
        this.entityId = -player.getEntityId() - 1000;
        try {
            arrayList = getHandle.invoke((Object)player, new Object[0]);
            Object obj = constructNamedEntitySpawnPacket.newInstance(arrayList);
            Reflection.setValue(obj, "a", this.entityId);
            String string = constructMetaPacket.newInstance(this.entityId, getDataWatcherB.invoke(getDataWatcher.invoke(arrayList, new Object[0]), new Object[0]));
            Location location = this.location.clone();
            location.setY(0.0);
            Object obj2 = constructRelEntityMovePacket.newInstance(this.entityId, (short)0, (short)(versionId > 8 ? -60.8 : 0.0), (short)0, false);
            for (Player player2 : Main.getInstance().getConfiguration().getGameArena(player).getDisplayedPlayers()) {
                player2.sendBlockChange(location, Bukkit.getServer().createBlockData(Material.LEGACY_BED_BLOCK));
                this.sendPacket(player2, obj);
                this.sendPacket(player2, obj2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        new BukkitRunnable(){

            public void run() {
                GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(player);
                if (gameArena != null) {
                    for (Player player2 : gameArena.getDisplayedPlayers()) {
                        if (player.equals(player2)) continue;
                        player2.hidePlayer(player);
                    }
                }
            }
        }.runTaskLater((Plugin)Main.getInstance(), 10L);
        arrayList = new ArrayList<String>();
        this.hologramStringList = Main.getInstance().getConfig().getStringList("Revive.Hologram");
        for (String string : this.hologramStringList) {
            arrayList.add(Configuration.translateTextCodes(string).replace("%time%", String.valueOf(Main.getInstance().getConfig().getDouble("Revive.Time"))));
        }
        this.hologram = new Hologram(this.location.clone().add(0.0, 1.5, 0.0));
        this.hologram.setCleanLines(arrayList);
        this.hologram.spawn();
        this.invisibleArmorStand = (ArmorStand)this.location.getWorld().spawn(this.location.clone().add(0.0, -0.5, 0.0), ArmorStand.class);
        this.invisibleArmorStand.setMetadata("Unknown", (MetadataValue)new FixedMetadataValue((Plugin)Main.getInstance(), (Object)"Unknown"));
        this.invisibleArmorStand.setMarker(true);
        this.invisibleArmorStand.setVisible(false);
        this.invisibleArmorStand.setGravity(false);
        this.invisibleArmorStand.setPassenger((Entity)player);
        player.getWorld().playSound(player.getLocation(), Sound.valueOf((String)Main.getInstance().getConfiguration().getSound("KnockedDown")), 1.0f, Main.getInstance().getConfiguration().convertDouble("SoundPitch.ReviveKnockedDown"));
        this.reviveTime = Main.getInstance().getConfig().getDouble("Revive.Time");
        this.active = true;
        return this;
    }

    public RevivePlayer sendUpdateStatus(Player player) {
        try {
            Object obj;
            Object object = getHandle.invoke((Object)this.player, new Object[0]);
            Object obj2 = constructNamedEntitySpawnPacket.newInstance(object);
            Reflection.setValue(obj2, "a", this.entityId);
            Object obj3 = constructMetaPacket.newInstance(this.entityId, getDataWatcherB.invoke(getDataWatcher.invoke(object, new Object[0]), new Object[0]));
            if (versionId < 14) {
                obj = constructBlockPosition.newInstance(this.location.getBlockX(), 0, this.location.getBlockZ());
                Reflection.setValue(obj3, "b", obj);
            }
            obj = constructRelEntityMovePacket.newInstance(this.entityId, (short)0, (short)(versionId > 8 ? -60.8 : 0.0), (short)0, false);
            Location location = this.location.clone();
            location.setY(0.0);
            player.sendBlockChange(location, Bukkit.getServer().createBlockData(Material.LEGACY_BED_BLOCK));
            this.sendPacket(player, obj2);
            this.sendPacket(player, obj);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        new BukkitRunnable(){

            public void run() {
                GameArena gameArena = Main.getInstance().getConfiguration().getGameArena(RevivePlayer.this.player);
                if (gameArena != null) {
                    for (Player player : gameArena.getDisplayedPlayers()) {
                        if (RevivePlayer.this.player.equals(player)) continue;
                        player.hidePlayer(RevivePlayer.this.player);
                    }
                }
            }
        }.runTaskLater((Plugin)Main.getInstance(), 10L);
        return this;
    }

    public RevivePlayer resetStatus() {
        return this.resetStatus(false);
    }

    public RevivePlayer resetStatus(boolean bl) {
        if (Main.getInstance().getConfiguration().getGameArena(this.player) == null) {
            return this;
        }
        if (this.isSneaking()) {
            this.title.sendReset(Arrays.asList(this.player));
            this.setSneaking(false);
        }
        if (this.active) {
            this.invisibleArmorStand.remove();
            this.active = false;
            for (Player object : Main.getInstance().getConfiguration().getGameArena(this.player).getDisplayedPlayers()) {
                if (object.equals(this.player)) continue;
                object.showPlayer(this.player);
            }
            this.player.removePotionEffect(PotionEffectType.INVISIBILITY);
            this.player.teleport(this.respawnLocation);
            try {
                Iterator<Object> iterator = constructEntityDestroyPacket.newInstance(new Object[]{new int[]{this.entityId}});
                for (Player player : Main.getInstance().getConfiguration().getGameArena(this.getPlayer()).getDisplayedPlayers()) {
                    this.sendPacket(player, iterator);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.hologram.destroy();
            if (!bl) {
                Main.getInstance().getConfiguration().getGameArena(this.player).removeRevivePlayer(this.player, false);
            }
        }
        return this;
    }

    public RevivePlayer resetStatus(Player player) {
        if (Main.getInstance().getConfiguration().getGameArena(this.player) == null) {
            return this;
        }
        if (this.active) {
            try {
                Object obj = constructEntityDestroyPacket.newInstance(new Object[]{new int[]{this.entityId}});
                this.sendPacket(player, obj);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return this;
    }

    private void sendPacket(Player player, Object object) {
        try {
            if (object == null) {
                return;
            }
            Object object2 = getHandle.invoke((Object)player, new Object[0]);
            Object object3 = Reflection.getValue(object2, "c");
            Method method = Reflection.getMethod(object3, "a", packet);
            assert (method != null);
            method.invoke(object3, object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isSneaking() {
        return this.sneaking;
    }

    public RevivePlayer setSneaking(boolean bl) {
        this.sneaking = bl;
        return this;
    }

    public Location getLocation() {
        return this.location;
    }

    public Hologram getHologram() {
        return this.hologram;
    }

    private Location getLocation(Player player, int n) {
        Location location = player.getLocation();
        if (location.getBlockY() < 0) {
            return null;
        }
        for (int i = location.getBlockY(); i >= 0; --i) {
            Block block = location.getWorld().getBlockAt(location.getBlockX(), i, location.getBlockZ());
            Material material = block.getType();
            if (!material.isSolid()) continue;
            return new Location(location.getWorld(), location.getX(), (double)(i + n), location.getZ());
        }
        return null;
    }

    static {
        versionId = Integer.parseInt(Bukkit.getBukkitVersion().split("-")[0].replace(".", "#").split("#")[1]);
    }
}

