/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.actions;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.actions.CommandAction;
import io.github.battlepass.actions.ConsoleCommandAction;
import io.github.battlepass.actions.MenuAction;
import io.github.battlepass.actions.MessageAction;
import io.github.battlepass.actions.SoundAction;
import io.github.battlepass.actions.SubtitleAction;
import io.github.battlepass.actions.TitleAction;
import me.hyfe.simplespigot.annotations.Nullable;
import me.hyfe.simplespigot.menu.Menu;
import me.hyfe.simplespigot.text.replacer.Replacer;
import org.bukkit.entity.Player;

public abstract class Action {
    protected final String condition;
    protected final String value;

    public Action(String string, String string2) {
        this.condition = string;
        this.value = string2;
    }

    public static Action parse(String string) {
        String string2 = string.contains("(") && string.contains(")") ? string.substring(string.indexOf("(") + 1, string.indexOf(")")).toLowerCase() : "";
        String string3 = string.contains("{") && string.contains("}") ? string.substring(string.indexOf("{") + 1, string.indexOf("}")) : "";
        switch (string.contains("[") && string.contains("]") ? string.substring(string.indexOf("[") + 1, string.indexOf("]")).toLowerCase() : "") {
            case "menu": {
                return new MenuAction(string2, string3);
            }
            case "title": {
                return new TitleAction(string2, string3);
            }
            case "subtitle": {
                return new SubtitleAction(string2, string3);
            }
            case "message": {
                return new MessageAction(string2, string3);
            }
            case "sound": {
                return new SoundAction(string2, string3);
            }
            case "command": {
                return new CommandAction(string2, string3);
            }
            case "console-command": {
                return new ConsoleCommandAction(string2, string3);
            }
        }
        return null;
    }

    public static void executeSimple(Player player, Iterable<Action> iterable, @Nullable BattlePlugin battlePlugin, @Nullable Replacer replacer) {
        for (Action action : iterable) {
            if (action instanceof MessageAction) {
                ((MessageAction)action).accept(player, replacer);
                continue;
            }
            if (action instanceof SoundAction) {
                ((SoundAction)action).accept(player);
                continue;
            }
            if (action instanceof TitleAction) {
                ((TitleAction)action).accept(player, replacer);
                continue;
            }
            if (action instanceof SubtitleAction) {
                ((SubtitleAction)action).accept(player, replacer);
                continue;
            }
            if (action instanceof CommandAction) {
                ((CommandAction)action).accept(player, replacer);
                continue;
            }
            if (action instanceof ConsoleCommandAction) {
                ((ConsoleCommandAction)action).accept(replacer);
                continue;
            }
            if (!(action instanceof MenuAction) || battlePlugin == null) continue;
            Menu menu = battlePlugin.getMenuFactory().getOpenMenus().get(player.getUniqueId());
            if (menu == null) {
                return;
            }
            ((MenuAction)action).accept(battlePlugin.getMenuFactory(), menu, player);
        }
    }
}

