/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.api.events.user;

import io.github.battlepass.objects.quests.Quest;
import io.github.battlepass.objects.user.User;
import java.math.BigInteger;
import java.util.function.Consumer;
import net.advancedplugins.bp.impl.actions.ActionExecution;
import org.bukkit.event.Cancellable;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;

public class UserQuestProgressionEvent
extends Event
implements Cancellable {
    private static final HandlerList HANDLER_LIST = new HandlerList();
    private final User user;
    private final Quest quest;
    private BigInteger addedProgress;
    private boolean isCancelled;

    public UserQuestProgressionEvent(ActionExecution actionExecution, Quest quest) {
        super(true);
        this.user = (User)actionExecution.getUser();
        this.quest = quest;
        this.addedProgress = actionExecution.getProgress();
    }

    public User getUser() {
        return this.user;
    }

    public Quest getQuest() {
        return this.quest;
    }

    public BigInteger getAddedProgress() {
        return this.addedProgress;
    }

    public void setAddedProgress(BigInteger bigInteger) {
        this.addedProgress = bigInteger;
    }

    public void ifNotCancelled(Consumer<UserQuestProgressionEvent> consumer) {
        if (!this.isCancelled) {
            consumer.accept(this);
        }
    }

    public boolean isCancelled() {
        return this.isCancelled;
    }

    public void setCancelled(boolean bl) {
        this.isCancelled = bl;
    }

    public static HandlerList getHandlerList() {
        return HANDLER_LIST;
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLER_LIST;
    }
}

