/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.cache;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.enums.Category;
import io.github.battlepass.objects.quests.Quest;
import io.github.battlepass.validator.QuestValidator;
import java.io.File;
import java.math.BigInteger;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import me.hyfe.simplespigot.cache.SimpleCache;
import me.hyfe.simplespigot.config.Config;
import me.hyfe.simplespigot.item.SpigotItem;
import net.advancedplugins.bp.impl.actions.objects.variable.Variable;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class QuestCache
extends SimpleCache<String, Map<String, Quest>> {
    private final BattlePlugin plugin;
    private final Path dataFolder;
    private final QuestValidator questValidator;
    private final Set<Integer> notifyAt;
    private final Set<Quest> weeklyQuests = Sets.newHashSet();
    private final Set<String> placeholderTypes = Sets.newHashSet();
    private boolean questsFinishedLoading = false;
    private int maxWeek = 0;

    public QuestCache(BattlePlugin battlePlugin) {
        this.plugin = battlePlugin;
        this.dataFolder = battlePlugin.getDataFolder().toPath();
        this.questValidator = battlePlugin.getQuestValidator();
        this.notifyAt = Sets.newHashSet(battlePlugin.getConfig("settings").list("current-season.notify-at-percentages"));
    }

    public Set<Quest> getAllQuests() {
        HashSet hashSet = Sets.newHashSet(this.weeklyQuests);
        hashSet.addAll(this.plugin.getDailyQuestReset().getCurrentQuests());
        return hashSet;
    }

    public Quest getQuest(String string, String string2) {
        Quest quest = this.getQuests(string).get(string2);
        if (!this.questsFinishedLoading) {
            this.plugin.log("(QuestCache) MAJOR -> getQuest method called before quests finished loading.");
        }
        this.plugin.log("(QuestCache) getQuest method returned ".concat(quest == null ? "null" : String.valueOf(quest)));
        return quest;
    }

    @NotNull
    public Map<String, Quest> getQuests(String string) {
        return this.get(string).orElseGet(() -> this.set(string, Maps.newLinkedHashMap()));
    }

    @Nullable
    public Map<String, Quest> getQuestsVerbatim(String string) {
        return this.get(string).orElse(null);
    }

    public int getMaxWeek() {
        return this.maxWeek;
    }

    public void cache() {
        this.createDefaultFiles();
        Set set = Files.walk(this.dataFolder.resolve("quests"), new FileVisitOption[0]).map(Path::toFile).filter(file -> file.getName().endsWith("-quests.yml")).collect(Collectors.toSet());
        for (File file2 : set) {
            String string = file2.getName().replace("-quests.yml", "");
            if (!string.contains("daily") && !string.contains("week")) {
                BattlePlugin.logger().warning("Failed to load the ".concat(string).concat(" quests"));
                continue;
            }
            Config config = new Config((Plugin)this.plugin, file2, true, new String[0]);
            AtomicInteger atomicInteger = new AtomicInteger();
            Set<String> set2 = config.keys("quests", false);
            if (set2 != null) {
                for (String string2 : set2) {
                    Quest quest = this.parseSection(config, string2, string, "quests.".concat(string2).concat("."));
                    if (quest == null || !this.questValidator.checkQuest(quest, atomicInteger)) continue;
                    if (quest.getType().startsWith("placeholderapi_")) {
                        this.placeholderTypes.add(quest.getType());
                    }
                    this.getQuests(string).put(string2, quest);
                    if (!string.contains("week")) continue;
                    this.weeklyQuests.add(quest);
                }
            }
            this.maxWeek = Math.max(this.maxWeek, Category.stripWeek(string));
            BattlePlugin.logger().info("Finished loading the " + string + " quests. ".concat(atomicInteger.intValue() == 0 ? "All quests loaded successfully." : atomicInteger.toString() + " quests failed to load. See the console for more info."));
        }
        BattlePlugin.getPlugin().getActionRegistry().placeholderAPI(this.placeholderTypes);
        this.questsFinishedLoading = true;
    }

    public Set<String> getPlaceholderTypes() {
        return this.placeholderTypes;
    }

    private Quest parseSection(Config config, String string, String string2, String string3) {
        try {
            String string4 = config.string(string3.concat("name"));
            ItemStack itemStack = SpigotItem.toItem(config, string3.concat("item"));
            if (!string2.equals("daily") && BattlePlugin.getPlugin().getConfig().getBoolean("weekly-quest-item-amounts")) {
                itemStack.setAmount(Integer.parseInt(string2.replace("week-", "")));
            }
            String string5 = config.string(string3.concat("type"));
            BigInteger bigInteger = new BigInteger(config.forcedString(string3.concat("required-progress")));
            int n = config.integer(string3.concat("points"));
            String string6 = config.string(string3.concat("exclusive"));
            boolean bl = config.bool(string3.concat("anti-abuse"));
            HashSet hashSet = Sets.newHashSet(config.stringList(string3.concat("whitelisted-worlds")));
            HashSet hashSet2 = Sets.newHashSet(config.stringList(string3.concat("blacklisted-worlds")));
            HashSet hashSet3 = Sets.newHashSet(config.stringList(string3.concat("blacklisted-regions")));
            HashSet hashSet4 = Sets.newHashSet(config.stringList(string3.concat("whitelisted-regions")));
            return new Quest(string, string2, string4, itemStack, string5, bigInteger, Variable.of(config.getConfiguration(), string3), n, this.notifyAt, hashSet, hashSet2, hashSet4, hashSet3, string6, bl, config);
        }
        catch (Exception exception) {
            BattlePlugin.logger().severe("Failed to load " + string + " quest from category " + string2 + ", section: " + string3);
            exception.printStackTrace();
            return null;
        }
    }

    public Set<String> getCategories() {
        return this.keySet();
    }

    private void createDefaultFiles() {
        Path path = this.dataFolder.resolve("quests");
        if (path.toFile().exists()) {
            return;
        }
        this.plugin.saveResource("quests/daily-quests.yml", false);
        this.plugin.saveResource("quests/week-1-quests.yml", false);
        this.plugin.saveResource("quests/week-2-quests.yml", false);
        this.plugin.saveResource("quests/week-3-quests.yml", false);
        this.plugin.saveResource("quests/week-4-quests.yml", false);
    }
}

