/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.cache;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.objects.reward.CommandReward;
import io.github.battlepass.objects.reward.ItemReward;
import io.github.battlepass.objects.reward.Reward;
import java.util.List;
import me.hyfe.simplespigot.cache.SimpleCache;
import me.hyfe.simplespigot.config.Config;
import me.hyfe.simplespigot.config.ConfigLoader;
import org.bukkit.inventory.ItemStack;

public class RewardCache
extends SimpleCache<String, Reward<?>> {
    private final BattlePlugin plugin;

    public RewardCache(BattlePlugin battlePlugin) {
        this.plugin = battlePlugin;
    }

    public void cache() {
        Config config = this.plugin.getConfig("rewards");
        ConfigLoader.reader(config).readWrap(reader -> reader.keyLoop(string -> {
            String string2 = reader.string("type");
            String string3 = reader.string("name") == null ? "Undefined" : reader.string("name");
            List<String> list = reader.list("lore-addon");
            if (string2 == null || string2.isEmpty()) {
                this.plugin.getLogger().warning("Failed to load reward cache: Reward ID: " + string + ", issue: Invalid Type");
            } else if (string2.equalsIgnoreCase("command")) {
                this.set(string, new CommandReward((String)string, string3, list, (Multiset<String>)HashMultiset.create(reader.list("commands"))));
            } else if (string2.equalsIgnoreCase("item")) {
                HashMultiset hashMultiset = HashMultiset.create();
                reader.keyLoop(string.concat(".items"), arg_0 -> RewardCache.lambda$cache$0((Multiset)hashMultiset, reader, arg_0));
                this.set(string, new ItemReward((String)string, string3, list, (Multiset<ItemStack>)hashMultiset));
            }
        }));
    }

    private static /* synthetic */ void lambda$cache$0(Multiset multiset, ConfigLoader.Reader reader, String string) {
        multiset.add((Object)reader.getItem(""));
    }
}

