/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.cache;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.api.events.user.UserLoadEvent;
import io.github.battlepass.exceptions.NoOnlineUserException;
import io.github.battlepass.loader.PassLoader;
import io.github.battlepass.objects.pass.PassType;
import io.github.battlepass.objects.user.User;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import me.hyfe.simplespigot.cache.FutureCache;
import me.hyfe.simplespigot.save.Savable;
import me.hyfe.simplespigot.storage.storage.Storage;
import me.hyfe.simplespigot.text.Text;
import me.hyfe.simplespigot.uuid.FastUuid;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class UserCache
extends FutureCache<UUID, User>
implements Savable {
    private final BattlePlugin plugin;
    private final Storage<User> storage;
    private final PassLoader passLoader;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    public UserCache(BattlePlugin battlePlugin) {
        super(battlePlugin);
        this.plugin = battlePlugin;
        this.storage = battlePlugin.getUserStorage();
        this.passLoader = battlePlugin.getPassLoader();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public User getOrThrow(UUID uUID) {
        User user = this.getSync(uUID).orElse(null);
        if (user == null) {
            Player player = Bukkit.getPlayer((UUID)uUID);
            if (player == null || !player.isOnline()) {
                throw new NoOnlineUserException("Could not find an online user with the uuid ".concat(FastUuid.toString(uUID)));
            }
            Text.sendMessage((CommandSender)player, "&ePlease re-log for this feature to work. We're sorry for the inconvenience.");
            return null;
        }
        this.applyPermissionComputation(user);
        return user;
    }

    public CompletableFuture<User> load(UUID uUID) {
        return ((CompletableFuture)this.get(uUID).thenApplyAsync(optional -> {
            if (!optional.isPresent()) {
                User user = this.storage.load(FastUuid.toString(uUID));
                boolean bl = false;
                if (user == null) {
                    user = new User(uUID);
                    bl = true;
                }
                this.set(uUID, user);
                UserLoadEvent userLoadEvent = new UserLoadEvent(user, bl);
                this.plugin.runSync(() -> Bukkit.getPluginManager().callEvent((Event)userLoadEvent));
                return user;
            }
            return (User)optional.get();
        }, (Executor)this.executorService)).exceptionally(throwable -> {
            throwable.printStackTrace();
            return null;
        });
    }

    public void asyncModifyMultiple(Consumer<User> consumer, Set<UUID> set) {
        for (UUID uUID : set) {
            this.load(uUID).thenAccept((Consumer)consumer);
        }
    }

    public void asyncModifyAll(Consumer<User> consumer) {
        this.plugin.runAsync(() -> {
            for (User user : this.values()) {
                consumer.accept(user);
            }
            for (User user : this.storage.loadAll()) {
                if (user == null || this.keySet().contains(user.getUuid())) continue;
                consumer.accept(user);
                this.storage.save(user.getUuid().toString(), user);
            }
        });
    }

    public void unload(UUID uUID, boolean bl) {
        this.get(uUID).thenAccept(optional -> {
            optional.ifPresent(user -> this.storage.save(FastUuid.toString(user.getUuid()), (User)user));
            if (bl) {
                this.invalidate(uUID);
            }
        });
    }

    public void loadOnline() {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.load(player.getUniqueId());
        }
    }

    @Override
    public void save(boolean bl) {
        if (this.plugin.isEnabled() && !bl) {
            this.plugin.runAsync(() -> {
                for (User user : this.values()) {
                    this.storage.save(FastUuid.toString(user.getUuid()), user);
                }
            });
        } else {
            for (User user : this.values()) {
                this.storage.save(FastUuid.toString(user.getUuid()), user);
            }
        }
    }

    private void applyPermissionComputation(User user) {
        Player player = Bukkit.getPlayer((UUID)user.getUuid());
        if (player == null) {
            return;
        }
        PassType passType = this.passLoader.passTypeOfId("premium");
        if (passType.getRequiredPermission() == null) {
            return;
        }
        if (!user.getPassId().equals(passType.getId()) && player.hasPermission(passType.getRequiredPermission())) {
            this.plugin.getLocalApi().setPassId(user, "premium");
        } else if (user.getPassId().equals(passType.getId()) && !player.hasPermission(passType.getRequiredPermission())) {
            user.setPassId("free");
        }
    }
}

