/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.cache.listener;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.cache.UserCache;
import io.github.battlepass.lang.Lang;
import io.github.battlepass.objects.user.User;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import me.hyfe.simplespigot.config.Config;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class ConnectionListener
implements Listener {
    private static ConnectionListener connectionListener;
    private final BattlePlugin plugin;
    private final UserCache userCache;
    private final Lang lang;
    private final boolean bungeeFix;
    private final boolean notificationEnabled;

    public ConnectionListener(BattlePlugin battlePlugin) {
        connectionListener = this;
        this.plugin = battlePlugin;
        this.userCache = battlePlugin.getUserCache();
        this.lang = battlePlugin.getLang();
        this.bungeeFix = battlePlugin.getConfig("settings").bool("storage-options.bungee-fix");
        this.notificationEnabled = this.lang.has("collectable-rewards-notification");
    }

    public static ConnectionListener getConnectionListener() {
        return connectionListener;
    }

    @EventHandler
    public void onJoin(PlayerJoinEvent playerJoinEvent) {
        Player player = playerJoinEvent.getPlayer();
        if (this.bungeeFix) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> this.loadPlayer(player), 20L);
        } else {
            this.loadPlayer(player);
        }
    }

    @EventHandler
    public void onQuit(PlayerQuitEvent playerQuitEvent) {
        this.userCache.unload(playerQuitEvent.getPlayer().getUniqueId(), true);
    }

    public void loadPlayer(Player player) {
        CompletableFuture<User> completableFuture = this.userCache.load(player.getUniqueId());
        if (!this.notificationEnabled) {
            return;
        }
        ((CompletableFuture)completableFuture.thenAccept(user -> {
            Predicate<String> predicate = string -> user.getPendingTiers((String)string) != null && !user.getPendingTiers((String)string).isEmpty();
            if (predicate.test("free") || predicate.test("premium")) {
                this.messageDelay(() -> this.lang.external("collectable-rewards-notification", replacer -> replacer.set("player", player.getName())).to((CommandSender)player));
            }
        })).exceptionally(throwable -> {
            throwable.printStackTrace();
            return null;
        });
    }

    private void messageDelay(Runnable runnable) {
        Config config = this.plugin.getConfig("settings");
        if (config.has("join-message-delay")) {
            int n = config.integer("join-message-delay");
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, runnable, 20L * (long)n);
        } else {
            runnable.run();
        }
    }
}

