/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.commands.bp;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.api.BattlePassApi;
import io.github.battlepass.cache.UserCache;
import io.github.battlepass.commands.BpSubCommand;
import io.github.battlepass.loader.PassLoader;
import java.math.BigInteger;
import me.hyfe.simplespigot.text.Text;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class StatsSub
extends BpSubCommand<Player> {
    private final UserCache userCache;
    private final PassLoader passLoader;
    private final BattlePassApi api;
    private final boolean blockPermissionEnabled;

    public StatsSub(BattlePlugin battlePlugin) {
        super(battlePlugin, "battlepass.use");
        this.userCache = battlePlugin.getUserCache();
        this.passLoader = battlePlugin.getPassLoader();
        this.api = battlePlugin.getLocalApi();
        this.blockPermissionEnabled = battlePlugin.getConfig("settings").bool("enable-ban-permission");
        this.addFlat("stats");
    }

    @Override
    public void onExecute(Player player, String[] stringArray) {
        if (this.blockPermissionEnabled && player.hasPermission("battlepass.block") && !player.hasPermission("battlepass.admin")) {
            this.lang.external("disallowed-permission").to((CommandSender)player);
            return;
        }
        if (!this.lang.has("stats-command")) {
            player.sendMessage(Text.modify("&cThe stats command is not configured."));
            return;
        }
        this.userCache.get(player.getUniqueId()).thenAccept(optional -> optional.ifPresent(user -> {
            String string = user.getPassId();
            String string2 = this.passLoader.passTypeOfId(string).getName();
            int n = user.getTier();
            int n2 = 0;
            for (int i = 1; i < n; ++i) {
                n2 += this.api.getRequiredPoints(i, string);
            }
            BigInteger bigInteger = user.getPoints().add(new BigInteger(String.valueOf(n2)));
            this.lang.external("stats-command", replacer -> replacer.set("player", player.getName()).set("pass_type", string2).set("pass_id", string).set("tier", n).set("points", user.getPoints()).set("required_points", this.api.getRequiredPoints(n + 1, string)).set("total_points", bigInteger.toString()).set("balance", user.getCurrency().toString())).to((CommandSender)player);
        }));
    }
}

