/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.commands.bpadmin.balance;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.commands.BpSubCommand;
import io.github.battlepass.objects.user.User;
import java.math.BigInteger;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;

public class RemoveBalanceSub
extends BpSubCommand<CommandSender> {
    public RemoveBalanceSub(BattlePlugin battlePlugin) {
        super(battlePlugin);
        this.inheritPermission();
        this.addFlats("remove");
        this.addFlatWithAliases("balance", "bal", "currency");
        this.addArgument(User.class, "player", (CommandSender commandSender) -> Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getName).collect(Collectors.toList()), new String[0]);
        this.addArgument(BigInteger.class, "amount", new String[0]);
    }

    @Override
    public void onExecute(CommandSender commandSender, String[] stringArray) {
        Optional optional = (Optional)this.parseArgument(stringArray, 2);
        if (!optional.isPresent()) {
            this.lang.external("could-not-find-user", replacer -> replacer.set("player", stringArray[2])).to(commandSender);
            return;
        }
        User user = (User)optional.get();
        BigInteger bigInteger = (BigInteger)this.parseArgument(stringArray, 3);
        if (bigInteger == null) {
            this.lang.local("invalid-number-input", new Object[0]);
            return;
        }
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)user.getUuid());
        if (offlinePlayer.getName() != null) {
            this.lang.local("removed-user-balance", bigInteger.toString(), offlinePlayer.getName()).to(commandSender);
        }
        user.updateCurrency(bigInteger2 -> bigInteger2.subtract(bigInteger));
    }
}

