/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.controller;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.cache.QuestCache;
import io.github.battlepass.objects.quests.Quest;
import io.github.battlepass.objects.user.User;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;

public class QuestController {
    private final QuestCache questCache;
    private final Function<User, Map<String, ConcurrentHashMap<String, BigInteger>>> questMap = user -> user.getQuestStore().asMap();

    public QuestController(BattlePlugin battlePlugin) {
        this.questCache = battlePlugin.getQuestCache();
    }

    public Map<String, BigInteger> getQuests(User user, String string) {
        return this.questMap.apply(user).get(string);
    }

    public boolean isQuestDone(User user, Quest quest) {
        return this.getQuestProgress(user, quest).compareTo(quest.getRequiredProgress()) > -1;
    }

    public boolean isWeekDone(User user, int n) {
        String string = "week-".concat(String.valueOf(n));
        Map<String, BigInteger> map = this.getQuests(user, string);
        if (map == null) {
            return n == 0;
        }
        for (Map.Entry<String, BigInteger> entry : map.entrySet()) {
            Quest quest = this.questCache.getQuest(string, entry.getKey());
            if (entry.getValue() == null || quest == null || entry.getValue().compareTo(quest.getRequiredProgress()) >= 0) continue;
            return false;
        }
        return true;
    }

    public boolean resetQuest(User user, Quest quest) {
        Map<String, BigInteger> map = this.getQuests(user, quest.getCategoryId());
        if (map == null) {
            return false;
        }
        map.remove(quest.getId());
        return true;
    }

    public BigInteger getQuestProgress(User user, Quest quest) {
        return this.failedIndex(user, quest) == FailedIndex.NONE ? this.getQuests(user, quest.getCategoryId()).get(quest.getId()) : BigInteger.ZERO;
    }

    public BigInteger setQuestProgress(User user, Quest quest, BigInteger bigInteger) {
        BigInteger bigInteger2 = quest.getRequiredProgress().min(bigInteger);
        this.fillFailedIndexes(user, quest);
        this.getQuests(user, quest.getCategoryId()).put(quest.getId(), bigInteger2);
        return bigInteger2;
    }

    public BigInteger addQuestProgress(User user, Quest quest, BigInteger bigInteger2, boolean bl) {
        BigInteger bigInteger3 = this.getQuestProgress(user, quest);
        if (bigInteger3.compareTo(quest.getRequiredProgress()) < 0) {
            BigInteger bigInteger4 = this.setQuestProgress(user, quest, bigInteger3.add(bigInteger2));
            if (bl && bigInteger4.compareTo(quest.getRequiredProgress()) > -1) {
                user.updatePoints(bigInteger -> bigInteger.add(BigInteger.valueOf(quest.getPoints())));
            }
            return bigInteger4;
        }
        return bigInteger3;
    }

    public BigInteger addQuestProgress(User user, Quest quest, BigInteger bigInteger) {
        return this.addQuestProgress(user, quest, bigInteger, false);
    }

    private void fillFailedIndexes(User user, Quest quest) {
        Predicate<FailedIndex> predicate = failedIndex -> this.failedIndex(user, quest).equals(failedIndex);
        if (predicate.test(FailedIndex.CATEGORY_LAYER)) {
            this.questMap.apply(user).put(quest.getCategoryId(), new ConcurrentHashMap());
        }
        if (predicate.test(FailedIndex.QUEST_LAYER)) {
            this.getQuests(user, quest.getCategoryId()).put(quest.getId(), BigInteger.ZERO);
        }
    }

    private FailedIndex failedIndex(User user, Quest quest) {
        if (!this.questMap.apply(user).containsKey(quest.getCategoryId())) {
            return FailedIndex.CATEGORY_LAYER;
        }
        if (!this.getQuests(user, quest.getCategoryId()).containsKey(quest.getId())) {
            return FailedIndex.QUEST_LAYER;
        }
        return FailedIndex.NONE;
    }

    private static enum FailedIndex {
        CATEGORY_LAYER,
        QUEST_LAYER,
        NONE;

    }
}

