/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.creator;

import io.github.battlepass.creator.GUICreator;
import io.github.battlepass.creator.gui.CreatorEditQuest;
import io.github.battlepass.creator.gui.CreatorMainMenu;
import io.github.battlepass.creator.gui.CreatorQuestList;
import io.github.battlepass.creator.listeners.ChatListener;
import java.util.HashMap;
import java.util.UUID;
import me.hyfe.simplespigot.text.Text;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class GUICreatorHandler {
    private HashMap<UUID, GUICreator> editors = new HashMap();
    private static GUICreatorHandler handler = null;
    private CreatorMainMenu creatorMainMenu;
    private CreatorQuestList creatorQuestList;
    private CreatorEditQuest creatorEditQuest;

    public GUICreatorHandler(JavaPlugin javaPlugin) {
        handler = this;
        this.loadInventories(javaPlugin);
    }

    public GUICreator getEditor(UUID uUID) {
        return this.editors.get(uUID);
    }

    public boolean isEditing(UUID uUID) {
        return this.editors.containsKey(uUID);
    }

    public void stopAllEditors() {
        this.editors.values().forEach(GUICreator::stop);
    }

    public static GUICreatorHandler getHandler() {
        if (handler == null) {
            return null;
        }
        return handler;
    }

    public void stopEditing(UUID uUID) {
        GUICreator gUICreator = this.editors.remove(uUID);
        if (gUICreator == null) {
            return;
        }
        gUICreator.stop();
    }

    public static String color(String string) {
        return Text.modify(string);
    }

    public void startNewEditor(Player player) {
        this.stopEditing(player.getUniqueId());
        GUICreator gUICreator = new GUICreator(player);
        this.editors.put(player.getUniqueId(), gUICreator);
    }

    public void openEditor(Player player) {
        if (this.isEditing(player.getUniqueId())) {
            GUICreator gUICreator = this.getEditor(player.getUniqueId());
            if (gUICreator.getQuest() != null) {
                CreatorEditQuest.open(player);
            } else if (gUICreator.getCategory() != null) {
                CreatorQuestList.open(player);
            } else {
                CreatorMainMenu.open(player);
            }
            return;
        }
        this.startNewEditor(player);
        CreatorMainMenu.open(player);
    }

    public CreatorEditQuest getCreatorEditQuest() {
        return this.creatorEditQuest;
    }

    public CreatorMainMenu getCreatorMainMenu() {
        return this.creatorMainMenu;
    }

    public CreatorQuestList getCreatorQuestList() {
        return this.creatorQuestList;
    }

    public void loadInventories(JavaPlugin javaPlugin) {
        this.creatorMainMenu = new CreatorMainMenu(javaPlugin);
        this.creatorQuestList = new CreatorQuestList(javaPlugin);
        this.creatorEditQuest = new CreatorEditQuest(javaPlugin);
        Bukkit.getPluginManager().registerEvents((Listener)new ChatListener(), (Plugin)javaPlugin);
    }
}

