/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.creator.gui;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.creator.GUICreator;
import io.github.battlepass.creator.gui.CreatorClickEvent;
import io.github.battlepass.creator.gui.CreatorMenu;
import io.github.battlepass.creator.gui.CreatorQuestList;
import java.util.Comparator;
import java.util.stream.Collectors;
import me.hyfe.simplespigot.item.SpigotItem;
import net.advancedplugins.bp.impl.actions.utils.MultiMaterial;
import net.advancedplugins.bp.impl.utils.nbt.NBTapi;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class CreatorMainMenu
extends CreatorMenu {
    private static CreatorMenu menu;

    public CreatorMainMenu(JavaPlugin javaPlugin) {
        super(javaPlugin);
        menu = this;
        this.setInvName("&aQuests Editor");
    }

    @Override
    void onEditorClick(CreatorClickEvent creatorClickEvent) {
        Player player = creatorClickEvent.getPlayer();
        GUICreator gUICreator = creatorClickEvent.getCreator();
        ItemStack itemStack = creatorClickEvent.getCurrentItem();
        int n = creatorClickEvent.getSlot();
        String string = NBTapi.get("action", itemStack);
        if (string == null || string.isEmpty()) {
            String string2 = NBTapi.get("edit", itemStack);
            if (string2 == null || string2.isEmpty()) {
                return;
            }
            player.closeInventory();
            gUICreator.setCategory(string2);
            gUICreator.setQuest(null);
            gUICreator.setPage(0);
            CreatorQuestList.open(player);
            return;
        }
        if (string.equalsIgnoreCase("close")) {
            player.closeInventory();
        } else if (!string.equalsIgnoreCase("next") && !string.equalsIgnoreCase("back") && string.equalsIgnoreCase("bp")) {
            player.performCommand("battlepass");
        }
    }

    public static void open(Player player) {
        Inventory inventory = Bukkit.createInventory(null, (int)18, (String)menu.getInvName());
        for (String string2 : BattlePlugin.getPlugin().getQuestCache().getCategories().stream().sorted(Comparator.comparing(string -> string)).collect(Collectors.toList())) {
            SpigotItem.Builder builder = SpigotItem.builder().item(Material.matchMaterial((String)"BOOK"));
            builder.name(CreatorMainMenu.color("&7Edit &e" + string2 + " &7Quests"));
            builder.lore(CreatorMainMenu.color("&e(!) &7&oLeft-Click&7 to start editing quest category"));
            inventory.addItem(new ItemStack[]{NBTapi.addNBTTag("edit", string2, builder.build())});
        }
        for (int i = inventory.getSize() - 9; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null && !inventory.getItem(i).getType().name().equalsIgnoreCase("AIR")) continue;
            inventory.setItem(i, SpigotItem.builder().item(MultiMaterial.BLACK_STAINED_GLASS_PANE.getMaterial()).name(" ").build());
        }
        inventory.setItem(inventory.getSize() - 5, SpigotItem.builder().item(Material.matchMaterial((String)"PAPER")).name(CreatorMainMenu.color("&eSelect a quest category and start editing.")).build());
        inventory.setItem(inventory.getSize() - 8, NBTapi.addNBTTag("action", "bp", SpigotItem.builder().item(Material.matchMaterial((String)"CHEST")).name(CreatorMainMenu.color("&eOpen BattlePass Main Menu.")).build()));
        player.openInventory(inventory);
    }
}

