/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.creator.gui;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.creator.GUICreator;
import io.github.battlepass.creator.GUICreatorHandler;
import io.github.battlepass.creator.gui.CreatorClickEvent;
import io.github.battlepass.creator.gui.CreatorEditQuest;
import io.github.battlepass.creator.gui.CreatorMainMenu;
import io.github.battlepass.creator.gui.CreatorMenu;
import io.github.battlepass.objects.quests.Quest;
import java.util.ArrayList;
import java.util.Collection;
import me.hyfe.simplespigot.item.SpigotItem;
import net.advancedplugins.bp.impl.actions.utils.MultiMaterial;
import net.advancedplugins.bp.impl.utils.nbt.NBTapi;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.java.JavaPlugin;

public class CreatorQuestList
extends CreatorMenu {
    private static CreatorMenu menu;

    public CreatorQuestList(JavaPlugin javaPlugin) {
        super(javaPlugin);
        menu = this;
        this.setInvName("&aQuest View");
    }

    @Override
    void onEditorClick(CreatorClickEvent creatorClickEvent) {
        Player player = creatorClickEvent.getPlayer();
        GUICreator gUICreator = creatorClickEvent.getCreator();
        ItemStack itemStack = creatorClickEvent.getCurrentItem();
        int n = creatorClickEvent.getSlot();
        String string = NBTapi.get("action", itemStack);
        if (string == null || string.isEmpty()) {
            String string2 = NBTapi.get("edit", itemStack);
            if (string2 == null || string2.isEmpty()) {
                return;
            }
            player.closeInventory();
            gUICreator.setQuest(BattlePlugin.getPlugin().getQuestCache().getQuest(gUICreator.getCategory(), string2));
            CreatorEditQuest.open(player);
            return;
        }
        if (string.equalsIgnoreCase("close")) {
            player.closeInventory();
        } else if (string.equalsIgnoreCase("next")) {
            int n2 = gUICreator.getPage();
            if (n2 + 1 > BattlePlugin.getPlugin().getQuestCache().getQuests(gUICreator.getCategory()).values().size() / 18) {
                return;
            }
            gUICreator.setPage(n2 + 1);
            CreatorQuestList.open(player);
        } else if (string.equalsIgnoreCase("back")) {
            int n3 = gUICreator.getPage();
            if (n3 - 1 <= -1) {
                return;
            }
            gUICreator.setPage(n3 - 1);
            CreatorQuestList.open(player);
        } else if (string.equalsIgnoreCase("menu")) {
            gUICreator.setPage(0);
            gUICreator.setCategory(null);
            CreatorMainMenu.open(player);
        } else if (string.equalsIgnoreCase("create")) {
            gUICreator.createNewQuest();
            CreatorEditQuest.open(player);
        }
    }

    public static void open(Player player) {
        Inventory inventory = Bukkit.createInventory(null, (int)27, (String)menu.getInvName());
        GUICreator gUICreator = GUICreatorHandler.getHandler().getEditor(player.getUniqueId());
        int n = gUICreator.getPage();
        Collection<Quest> collection = BattlePlugin.getPlugin().getQuestCache().getQuests(gUICreator.getCategory()).values();
        int n2 = n * 18 + 1;
        for (Quest quest : new ArrayList<Quest>(collection).subList(18 * n, Math.min(18 * (n + 1), collection.size()))) {
            SpigotItem.Builder builder = SpigotItem.builder().item(Material.matchMaterial((String)"PAPER"));
            builder.name(CreatorQuestList.color("&7Edit &e" + quest.getName() + " &7Quest"));
            builder.lore(CreatorQuestList.color("&7 - &eQuest Type: &7" + quest.getType()), CreatorQuestList.color("&7 - &eQuest Class: &7" + (quest.getExclusiveTo() != null && quest.getExclusiveTo().equalsIgnoreCase("premium") ? "Premium" : "Free")), " ", CreatorQuestList.color("&e(!) &7&oLeft-Click&7 to start editing this quest"));
            builder.amount(n2);
            inventory.addItem(new ItemStack[]{NBTapi.addNBTTag("edit", quest.getId(), builder.build())});
            ++n2;
        }
        for (int i = inventory.getSize() - 9; i < inventory.getSize(); ++i) {
            if (inventory.getItem(i) != null && !inventory.getItem(i).getType().name().equalsIgnoreCase("AIR")) continue;
            inventory.setItem(i, SpigotItem.builder().item(MultiMaterial.BLACK_STAINED_GLASS_PANE.getMaterial()).name(" ").build());
        }
        inventory.setItem(inventory.getSize() - 5, SpigotItem.builder().item(Material.matchMaterial((String)"BOOK")).name(CreatorQuestList.color("&eSelect a quest to edit.")).build());
        inventory.setItem(inventory.getSize() - 1, NBTapi.addNBTTag("action", "menu", SpigotItem.builder().item(Material.matchMaterial((String)"IRON_DOOR")).name(CreatorQuestList.color("&eGo back to category view")).build()));
        inventory.setItem(inventory.getSize() - 8, NBTapi.addNBTTag("action", "create", SpigotItem.builder().item(MultiMaterial.LIME_WOOL.getMaterial()).name(CreatorQuestList.color("&eCreate a new quest")).build()));
        inventory.setItem(inventory.getSize() - 4, NBTapi.addNBTTag("action", "next", SpigotItem.builder().head("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMTliZjMyOTJlMTI2YTEwNWI1NGViYTcxM2FhMWIxNTJkNTQxYTFkODkzODgyOWM1NjM2NGQxNzhlZDIyYmYifX19").name(CreatorQuestList.color("&8>> &6Next Page")).build()));
        inventory.setItem(inventory.getSize() - 6, NBTapi.addNBTTag("action", "back", SpigotItem.builder().head("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvYmQ2OWUwNmU1ZGFkZmQ4NGU1ZjNkMWMyMTA2M2YyNTUzYjJmYTk0NWVlMWQ0ZDcxNTJmZGM1NDI1YmMxMmE5In19fQ").name(CreatorQuestList.color("&8<< &6Previous Page")).build()));
        player.openInventory(inventory);
    }
}

