/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.creator.states;

import io.github.battlepass.creator.requests.ChatInputType;
import java.util.Arrays;
import org.bukkit.Material;

public enum QuestSetting {
    TYPE("Quest's type", 0, "Controls when quest activates", ChatInputType.STRING, "type", Material.matchMaterial((String)"COMMAND_BLOCK"), "https://battlepass.advancedplugins.net/features/quests", "block-break"),
    VARIABLE("Quest's variable", 1, "Filter to specific req. quest activates, set none to disable", ChatInputType.OBJECT, "variable", Material.matchMaterial((String)"HOPPER"), "https://battlepass.advancedplugins.net/features/setting-up-and-using-variables", "stone"),
    NAME("Quest's name", 3, "The quest's name", ChatInputType.STRING, "name", Material.matchMaterial((String)"NAME_TAG"), null, "New Quest"),
    REQUIRED_PROGRESS("Required Progress", 4, "Times quest type activates to complete it", ChatInputType.INT, "required-progress", Material.matchMaterial((String)"REPEATER"), "https://battlepass.advancedplugins.net/features/quests", 10),
    POINTS("Rewarded Points", 5, "Points player is rewarded for completing quest", ChatInputType.INT, "points", Material.matchMaterial((String)"EXPERIENCE_BOTTLE"), "https://battlepass.advancedplugins.net/tutorials/linking-rewards-to-tiers", 1),
    PREMIUM("Quest Exclusivity", 13, "Whether the quest is 'premium' or 'free'", ChatInputType.STRING, "exclusive", Material.matchMaterial((String)"EMERALD"), "https://battlepass.advancedplugins.net/tutorials/linking-rewards-to-tiers", "free"),
    ITEM_MATERIAL("Display item's material", 7, "Configure displayed item's material", ChatInputType.MATERIAL, "item.material", Material.matchMaterial((String)"PAPER"), "https://hub.spigotmc.org/javadocs/bukkit/org/bukkit/Material.html", "DIAMOND_PICKAXE"),
    ITEM_NAME("Display item's name", 8, "Configure displayed item's name", ChatInputType.STRING, "item.name", Material.matchMaterial((String)"PAPER"), null, "&eFreshly Created Quest"),
    ITEM_LORE("Display item's lore", 16, "Configure displayed item's lore", ChatInputType.LIST, "item.lore", Material.matchMaterial((String)"PAPER"), null, Arrays.asList("&7Progress &e%total_progress%&7/&e%required_progress%"));

    private final String name;
    private final String desc;
    private final String link;
    private final String path;
    private final Object def;
    private final ChatInputType type;
    private final Material material;
    private final int slot;

    private QuestSetting(String string2, int n2, String string3, ChatInputType chatInputType, String string4, Material material, String string5, Object object) {
        this.name = string2;
        this.slot = n2;
        this.path = string4;
        this.desc = string3;
        this.type = chatInputType;
        this.material = material;
        this.link = string5;
        this.def = object;
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getLink() {
        return this.link;
    }

    public String getPath() {
        return this.path;
    }

    public Object getDef() {
        return this.def;
    }

    public ChatInputType getType() {
        return this.type;
    }

    public Material getMaterial() {
        return this.material;
    }

    public int getSlot() {
        return this.slot;
    }
}

