/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.hikari;

import io.github.battlepass.hikari.HikariConfig;
import io.github.battlepass.hikari.HikariConfigMXBean;
import io.github.battlepass.hikari.HikariPoolMXBean;
import io.github.battlepass.hikari.metrics.MetricsTrackerFactory;
import io.github.battlepass.hikari.pool.HikariPool;
import java.io.Closeable;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HikariDataSource
extends HikariConfig
implements DataSource,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HikariDataSource.class);
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final HikariPool fastPathPool;
    private volatile HikariPool pool;

    public HikariDataSource() {
        this.fastPathPool = null;
    }

    public HikariDataSource(HikariConfig hikariConfig) {
        hikariConfig.validate();
        hikariConfig.copyStateTo(this);
        LOGGER.info("{} - Starting...", (Object)hikariConfig.getPoolName());
        this.pool = this.fastPathPool = new HikariPool(this);
        LOGGER.info("{} - Start completed.", (Object)hikariConfig.getPoolName());
        this.seal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Connection getConnection() {
        if (this.isClosed()) {
            throw new SQLException("HikariDataSource " + this + " has been closed.");
        }
        if (this.fastPathPool != null) {
            return this.fastPathPool.getConnection();
        }
        HikariPool hikariPool = this.pool;
        if (hikariPool == null) {
            HikariDataSource hikariDataSource = this;
            synchronized (hikariDataSource) {
                hikariPool = this.pool;
                if (hikariPool == null) {
                    this.validate();
                    LOGGER.info("{} - Starting...", (Object)this.getPoolName());
                    try {
                        this.pool = hikariPool = new HikariPool(this);
                        this.seal();
                    }
                    catch (HikariPool.PoolInitializationException poolInitializationException) {
                        if (poolInitializationException.getCause() instanceof SQLException) {
                            throw (SQLException)poolInitializationException.getCause();
                        }
                        throw poolInitializationException;
                    }
                    LOGGER.info("{} - Start completed.", (Object)this.getPoolName());
                }
            }
        }
        return hikariPool.getConnection();
    }

    @Override
    public Connection getConnection(String string, String string2) {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PrintWriter getLogWriter() {
        HikariPool hikariPool = this.pool;
        return hikariPool != null ? hikariPool.getUnwrappedDataSource().getLogWriter() : null;
    }

    @Override
    public void setLogWriter(PrintWriter printWriter) {
        HikariPool hikariPool = this.pool;
        if (hikariPool != null) {
            hikariPool.getUnwrappedDataSource().setLogWriter(printWriter);
        }
    }

    @Override
    public void setLoginTimeout(int n) {
        HikariPool hikariPool = this.pool;
        if (hikariPool != null) {
            hikariPool.getUnwrappedDataSource().setLoginTimeout(n);
        }
    }

    @Override
    public int getLoginTimeout() {
        HikariPool hikariPool = this.pool;
        return hikariPool != null ? hikariPool.getUnwrappedDataSource().getLoginTimeout() : 0;
    }

    @Override
    public java.util.logging.Logger getParentLogger() {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) {
        if (clazz.isInstance(this)) {
            return (T)this;
        }
        HikariPool hikariPool = this.pool;
        if (hikariPool != null) {
            DataSource dataSource = hikariPool.getUnwrappedDataSource();
            if (clazz.isInstance(dataSource)) {
                return (T)dataSource;
            }
            if (dataSource != null) {
                return dataSource.unwrap(clazz);
            }
        }
        throw new SQLException("Wrapped DataSource is not an instance of " + clazz);
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) {
        if (clazz.isInstance(this)) {
            return true;
        }
        HikariPool hikariPool = this.pool;
        if (hikariPool != null) {
            DataSource dataSource = hikariPool.getUnwrappedDataSource();
            if (clazz.isInstance(dataSource)) {
                return true;
            }
            if (dataSource != null) {
                return dataSource.isWrapperFor(clazz);
            }
        }
        return false;
    }

    @Override
    public void setMetricRegistry(Object object) {
        boolean bl = this.getMetricRegistry() != null;
        super.setMetricRegistry(object);
        HikariPool hikariPool = this.pool;
        if (hikariPool != null) {
            if (bl) {
                throw new IllegalStateException("MetricRegistry can only be set one time");
            }
            hikariPool.setMetricRegistry(super.getMetricRegistry());
        }
    }

    @Override
    public void setMetricsTrackerFactory(MetricsTrackerFactory metricsTrackerFactory) {
        boolean bl = this.getMetricsTrackerFactory() != null;
        super.setMetricsTrackerFactory(metricsTrackerFactory);
        HikariPool hikariPool = this.pool;
        if (hikariPool != null) {
            if (bl) {
                throw new IllegalStateException("MetricsTrackerFactory can only be set one time");
            }
            hikariPool.setMetricsTrackerFactory(super.getMetricsTrackerFactory());
        }
    }

    @Override
    public void setHealthCheckRegistry(Object object) {
        boolean bl = this.getHealthCheckRegistry() != null;
        super.setHealthCheckRegistry(object);
        HikariPool hikariPool = this.pool;
        if (hikariPool != null) {
            if (bl) {
                throw new IllegalStateException("HealthCheckRegistry can only be set one time");
            }
            hikariPool.setHealthCheckRegistry(super.getHealthCheckRegistry());
        }
    }

    public boolean isRunning() {
        return this.pool != null && this.pool.poolState == 0;
    }

    public HikariPoolMXBean getHikariPoolMXBean() {
        return this.pool;
    }

    public HikariConfigMXBean getHikariConfigMXBean() {
        return this;
    }

    public void evictConnection(Connection connection) {
        HikariPool hikariPool;
        if (!this.isClosed() && (hikariPool = this.pool) != null && connection.getClass().getName().startsWith("io.github.battlepass.hikari")) {
            hikariPool.evictConnection(connection);
        }
    }

    @Override
    public void close() {
        if (this.isShutdown.getAndSet(true)) {
            return;
        }
        HikariPool hikariPool = this.pool;
        if (hikariPool != null) {
            try {
                LOGGER.info("{} - Shutdown initiated...", (Object)this.getPoolName());
                hikariPool.shutdown();
                LOGGER.info("{} - Shutdown completed.", (Object)this.getPoolName());
            }
            catch (InterruptedException interruptedException) {
                LOGGER.warn("{} - Interrupted during closing", (Object)this.getPoolName(), (Object)interruptedException);
                Thread.currentThread().interrupt();
            }
        }
    }

    public boolean isClosed() {
        return this.isShutdown.get();
    }

    public String toString() {
        return "HikariDataSource (" + this.pool + ")";
    }
}

