/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.hikari.metrics.prometheus;

import io.github.battlepass.hikari.metrics.PoolStats;
import io.prometheus.client.Collector;
import io.prometheus.client.GaugeMetricFamily;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;

class HikariCPCollector
extends Collector {
    private static final List<String> LABEL_NAMES = Collections.singletonList("pool");
    private final Map<String, PoolStats> poolStatsMap = new ConcurrentHashMap<String, PoolStats>();

    HikariCPCollector() {
    }

    public List<Collector.MetricFamilySamples> collect() {
        return Arrays.asList(this.createGauge("hikaricp_active_connections", "Active connections", PoolStats::getActiveConnections), this.createGauge("hikaricp_idle_connections", "Idle connections", PoolStats::getIdleConnections), this.createGauge("hikaricp_pending_threads", "Pending threads", PoolStats::getPendingThreads), this.createGauge("hikaricp_connections", "The number of current connections", PoolStats::getTotalConnections), this.createGauge("hikaricp_max_connections", "Max connections", PoolStats::getMaxConnections), this.createGauge("hikaricp_min_connections", "Min connections", PoolStats::getMinConnections));
    }

    void add(String string, PoolStats poolStats) {
        this.poolStatsMap.put(string, poolStats);
    }

    void remove(String string) {
        this.poolStatsMap.remove(string);
    }

    private GaugeMetricFamily createGauge(String string2, String string3, Function<PoolStats, Integer> function) {
        GaugeMetricFamily gaugeMetricFamily = new GaugeMetricFamily(string2, string3, LABEL_NAMES);
        this.poolStatsMap.forEach((string, poolStats) -> gaugeMetricFamily.addMetric(Collections.singletonList(string), (double)((Integer)function.apply((PoolStats)poolStats)).intValue()));
        return gaugeMetricFamily;
    }
}

