/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.hikari.metrics.prometheus;

import io.github.battlepass.hikari.metrics.IMetricsTracker;
import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.Counter;
import io.prometheus.client.Histogram;

class PrometheusHistogramMetricsTracker
implements IMetricsTracker {
    private static final Counter CONNECTION_TIMEOUT_COUNTER = ((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().name("hikaricp_connection_timeout_total")).labelNames(new String[]{"pool"})).help("Connection timeout total count")).create();
    private static final Histogram ELAPSED_ACQUIRED_HISTOGRAM = PrometheusHistogramMetricsTracker.registerHistogram("hikaricp_connection_acquired_nanos", "Connection acquired time (ns)", 1000.0);
    private static final Histogram ELAPSED_BORROWED_HISTOGRAM = PrometheusHistogramMetricsTracker.registerHistogram("hikaricp_connection_usage_millis", "Connection usage (ms)", 1.0);
    private static final Histogram ELAPSED_CREATION_HISTOGRAM = PrometheusHistogramMetricsTracker.registerHistogram("hikaricp_connection_creation_millis", "Connection creation (ms)", 1.0);
    private final Counter.Child connectionTimeoutCounterChild;
    private final Histogram.Child elapsedAcquiredHistogramChild;
    private final Histogram.Child elapsedBorrowedHistogramChild;
    private final Histogram.Child elapsedCreationHistogramChild;

    private static Histogram registerHistogram(String string, String string2, double d) {
        return ((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().name(string)).labelNames(new String[]{"pool"})).help(string2)).exponentialBuckets(d, 2.0, 11).create();
    }

    PrometheusHistogramMetricsTracker(String string, CollectorRegistry collectorRegistry) {
        this.registerMetrics(collectorRegistry);
        this.connectionTimeoutCounterChild = (Counter.Child)CONNECTION_TIMEOUT_COUNTER.labels(new String[]{string});
        this.elapsedAcquiredHistogramChild = (Histogram.Child)ELAPSED_ACQUIRED_HISTOGRAM.labels(new String[]{string});
        this.elapsedBorrowedHistogramChild = (Histogram.Child)ELAPSED_BORROWED_HISTOGRAM.labels(new String[]{string});
        this.elapsedCreationHistogramChild = (Histogram.Child)ELAPSED_CREATION_HISTOGRAM.labels(new String[]{string});
    }

    private void registerMetrics(CollectorRegistry collectorRegistry) {
        CONNECTION_TIMEOUT_COUNTER.register(collectorRegistry);
        ELAPSED_ACQUIRED_HISTOGRAM.register(collectorRegistry);
        ELAPSED_BORROWED_HISTOGRAM.register(collectorRegistry);
        ELAPSED_CREATION_HISTOGRAM.register(collectorRegistry);
    }

    @Override
    public void recordConnectionAcquiredNanos(long l) {
        this.elapsedAcquiredHistogramChild.observe((double)l);
    }

    @Override
    public void recordConnectionUsageMillis(long l) {
        this.elapsedBorrowedHistogramChild.observe((double)l);
    }

    @Override
    public void recordConnectionCreatedMillis(long l) {
        this.elapsedCreationHistogramChild.observe((double)l);
    }

    @Override
    public void recordConnectionTimeout() {
        this.connectionTimeoutCounterChild.inc();
    }
}

