/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.loader;

import com.google.common.collect.Maps;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.objects.pass.PassType;
import java.io.File;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import me.hyfe.simplespigot.config.Config;
import org.bukkit.plugin.Plugin;

public class PassLoader {
    private final Plugin plugin;
    private final Path dataFolder;
    private final Map<String, PassType> passTypes = Maps.newHashMap();
    private int maxTier = 0;

    public PassLoader(BattlePlugin battlePlugin) {
        this.plugin = battlePlugin;
        this.dataFolder = battlePlugin.getDataFolder().toPath().toAbsolutePath();
    }

    public Map<String, PassType> getPassTypes() {
        return this.passTypes;
    }

    public PassType passTypeOfId(String string) {
        return this.passTypes.get(string);
    }

    public int getMaxTier() {
        return this.maxTier;
    }

    public void load() {
        this.createDefaultFiles();
        Set set = Files.walk(this.dataFolder.resolve("passes"), new FileVisitOption[0]).map(Path::toFile).filter(file -> !file.getName().equals("passes")).collect(Collectors.toSet());
        for (File file2 : set) {
            String string = file2.getName().replace(".yml", "");
            if (!string.equalsIgnoreCase("free") && !string.equalsIgnoreCase("premium")) continue;
            Config config = new Config(this.plugin, file2, true, new String[0]);
            if (!config.has("name")) {
                BattlePlugin.logger().warning("Failed to load the pass type with the id: ".concat(string));
                continue;
            }
            PassType passType = new PassType(string, config);
            this.passTypes.put(string, passType);
            if (passType.getTiers().lastKey() > this.maxTier) {
                this.maxTier = passType.getTiers().lastKey();
            }
            BattlePlugin.logger().info("Successfully loaded the pass type with the id: ".concat(string));
        }
    }

    private void createDefaultFiles() {
        Path path = this.plugin.getDataFolder().toPath().resolve("passes");
        if (!path.resolve("free.yml").toFile().exists()) {
            this.plugin.saveResource("passes/free.yml", false);
        }
        if (!path.resolve("premium.yml").toFile().exists()) {
            this.plugin.saveResource("passes/premium.yml", false);
        }
    }
}

