/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.logger;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.loader.PassLoader;
import io.github.battlepass.logger.Zone;
import io.github.battlepass.logger.containers.BasicContainer;
import io.github.battlepass.logger.containers.LogContainer;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import me.hyfe.simplespigot.tuple.ImmutablePair;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class DebugLogger {
    private final BattlePlugin plugin;
    private final SimpleDateFormat lineTimeFormat = new SimpleDateFormat("[hh:mm:ss]");
    private final Set<LogContainer> backlog = Sets.newConcurrentHashSet();
    private final List<String> startupLog = Lists.newArrayList();
    private final Path debugFolder;
    private boolean startupOccurred = false;
    private boolean enabled = false;

    public DebugLogger(BattlePlugin battlePlugin) {
        this.plugin = battlePlugin;
        this.debugFolder = battlePlugin.getDataFolder().toPath().resolve("debug-files");
        this.makeBasePathIfNotExists();
    }

    public void log(String string) {
        this.log(new BasicContainer(string));
    }

    public void log(LogContainer logContainer) {
        if (this.enabled) {
            this.backlog.add(logContainer);
        }
    }

    public void log(Zone zone, String string) {
        if (zone == Zone.RELOAD) {
            this.log("(RELOAD) ".concat(string));
            return;
        }
        if (zone == Zone.START) {
            if (!this.startupOccurred) {
                this.startupLog.add(string);
                return;
            }
            this.log(Zone.RELOAD, string);
            return;
        }
        if (this.enabled) {
            this.log(string);
        }
    }

    public String dump(Predicate<LogContainer> predicate) {
        ImmutablePair<String, FileWriter> immutablePair = this.makeDebugFile();
        FileWriter fileWriter = immutablePair.getValue();
        List list = this.backlog.parallelStream().sorted(Collections.reverseOrder()).collect(Collectors.toList());
        this.writeRunningInfo(fileWriter);
        for (String object : this.startupLog) {
            this.writeLine(fileWriter, object);
        }
        fileWriter.write(System.getProperty("line.separator"));
        if (predicate != null) {
            for (LogContainer logContainer : list) {
                if (!predicate.test(logContainer)) continue;
                this.writeLine(fileWriter, this.lineTimeFormat.format(new Date(logContainer.getTime())).concat(" ").concat(logContainer.toString()));
            }
        } else {
            for (LogContainer logContainer : list) {
                this.writeLine(fileWriter, this.lineTimeFormat.format(new Date(logContainer.getTime())).concat(" ").concat(logContainer.toString()));
            }
        }
        fileWriter.close();
        return immutablePair.getKey();
    }

    private void writeRunningInfo(Writer writer) {
        this.writeLine(writer, "MC Server Version: ".concat(Bukkit.getVersion()));
        this.writeLine(writer, "Bukkit Version: ".concat(Bukkit.getBukkitVersion()));
        this.writeLine(writer, "BattlePass version: ".concat(this.plugin.getDescription().getVersion()));
        this.writeLine(writer, "Registered Authors: ".concat(String.join((CharSequence)", ", this.plugin.getDescription().getAuthors())));
        this.writeLine(writer, "Registered Hooks: ".concat(String.join((CharSequence)", ", this.plugin.getActionRegistry().getRegisteredHooks())));
        this.writeLine(writer, "Point Information: ".concat(this.getPassInfo()));
        this.writeLine(writer, System.getProperty("line.separator"));
    }

    private void writeLine(Writer writer, String string) {
        writer.write(string);
        writer.write(System.getProperty("line.separator"));
    }

    private String getPassInfo() {
        PassLoader passLoader = this.plugin.getPassLoader();
        return passLoader.passTypeOfId("free").getTotalPoints(passLoader.getMaxTier()) + " total free points and " + passLoader.passTypeOfId("premium").getTotalPoints(passLoader.getMaxTier()) + " total premium points.";
    }

    private ImmutablePair<String, FileWriter> makeDebugFile() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh-mm-ss");
        String string = simpleDateFormat.format(new Date(System.currentTimeMillis()));
        File file = this.debugFolder.resolve(string.concat(".txt")).toFile();
        FileWriter fileWriter = new FileWriter(file, false);
        return ImmutablePair.of(this.plugin.getDataFolder().toPath().toAbsolutePath().toString() + "\\" + file.getName(), fileWriter);
    }

    private void makeBasePathIfNotExists() {
        File file = this.debugFolder.toFile();
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    private void cleanup() {
        long l = System.currentTimeMillis();
        this.plugin.runAsync(() -> this.backlog.removeIf(logContainer -> l - logContainer.getTime() > 600000L));
    }

    public void finishedStartup(boolean bl) {
        this.startupOccurred = bl;
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, this::cleanup, 1200L, 1200L);
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void clear() {
        this.backlog.clear();
    }
}

