/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.menus.menus;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.api.BattlePassApi;
import io.github.battlepass.loader.PassLoader;
import io.github.battlepass.menus.UserDependent;
import io.github.battlepass.menus.service.extensions.ConfigMenu;
import io.github.battlepass.objects.user.User;
import io.github.battlepass.quests.workers.reset.DailyQuestReset;
import me.hyfe.simplespigot.config.Config;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class PortalMenu
extends ConfigMenu
implements UserDependent {
    private final BattlePassApi api;
    private final PassLoader passLoader;
    private final DailyQuestReset dailyQuestReset;
    private final User user;

    public PortalMenu(BattlePlugin battlePlugin, Config config, Player player) {
        super(battlePlugin, config, player);
        this.api = battlePlugin.getLocalApi();
        this.passLoader = battlePlugin.getPassLoader();
        this.dailyQuestReset = battlePlugin.getDailyQuestReset();
        this.user = battlePlugin.getUserCache().getOrThrow(player.getUniqueId());
    }

    @Override
    public void redraw() {
        this.drawConfigItems(replacer -> replacer.set("daily_time_left", this.dailyQuestReset.asString()).set("pass_type", this.passLoader.passTypeOfId(this.user.getPassId()).getName()).set("week", this.api.getWeekFormatted()).set("tier", this.user.getTier()).set("points", this.user.getPoints().toString()).set("required_points", this.api.getRequiredPoints(this.user.getTier(), this.user.getPassId())).tryAddPapi((OfflinePlayer)this.player));
    }

    @Override
    public boolean isUserViable() {
        return this.user != null;
    }
}

