/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.menus.menus;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.api.BattlePassApi;
import io.github.battlepass.cache.QuestCache;
import io.github.battlepass.controller.QuestController;
import io.github.battlepass.lang.Lang;
import io.github.battlepass.menus.MenuFactory;
import io.github.battlepass.menus.UserDependent;
import io.github.battlepass.menus.menus.WeekMenu;
import io.github.battlepass.menus.service.extensions.PageableConfigMenu;
import io.github.battlepass.objects.user.User;
import io.github.battlepass.quests.workers.reset.DailyQuestReset;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import me.hyfe.simplespigot.config.Config;
import me.hyfe.simplespigot.item.SpigotItem;
import me.hyfe.simplespigot.menu.item.MenuItem;
import me.hyfe.simplespigot.menu.service.MenuService;
import me.hyfe.simplespigot.tuple.ImmutablePair;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public class QuestOverviewMenu
extends PageableConfigMenu<Integer>
implements UserDependent {
    private final BattlePassApi api;
    private final MenuFactory menuFactory;
    private final QuestCache questCache;
    private final QuestController questController;
    private final DailyQuestReset dailyQuestReset;
    private final User user;
    private final Lang lang;

    public QuestOverviewMenu(BattlePlugin battlePlugin, Config config, Player player) {
        super(battlePlugin, config, player, replacer -> replacer.tryAddPapi((OfflinePlayer)player));
        this.api = battlePlugin.getLocalApi();
        this.menuFactory = battlePlugin.getMenuFactory();
        this.questCache = battlePlugin.getQuestCache();
        this.questController = battlePlugin.getQuestController();
        this.dailyQuestReset = battlePlugin.getDailyQuestReset();
        this.user = battlePlugin.getUserCache().getOrThrow(player.getUniqueId());
        this.lang = battlePlugin.getLang();
        this.addUpdater(battlePlugin, 20);
    }

    @Override
    public void redraw() {
        this.drawPageableItems(() -> this.drawConfigItems(replacer -> replacer.set("daily_time_left", this.dailyQuestReset.asString()).tryAddPapi((OfflinePlayer)this.player)));
    }

    @Override
    public MenuItem pageableItem(Integer n) {
        Config config = this.plugin.getConfig("settings");
        long l = this.api.getCurrentWeek();
        boolean bl = (long)n.intValue() > l;
        boolean bl2 = config.bool("current-season.unlocks.require-previous-completion") && this.config.has("static-items.requires-previous-completion-item") && !this.questController.isWeekDone(this.user, n - 1);
        boolean bl3 = config.bool("current-season.unlocks.lock-previous-weeks") && l > (long)n.intValue();
        boolean bl4 = this.user.bypassesLockedWeeks();
        boolean bl5 = !bl4 && (bl || bl2 || bl3 || this.api.getCurrentWeek() < 1L);
        return MenuItem.builderOf(SpigotItem.toItem(this.config, "static-items." + (bl5 ? (bl ? "locked-week" : "requires-previous-completion") : "week") + "-item", replacer -> replacer.set("week", n).set("status", this.lang.external("week-status-".concat(!bl5 ? "un" : "").concat("locked")).asString().concat(bl4 ? " &o&7(&cBYPASSING&7)" : "")).tryAddPapi((OfflinePlayer)this.player))).onClick((menuItem, clickType) -> {
            if (!bl5) {
                WeekMenu weekMenu = new WeekMenu(this.plugin, this.plugin.getConfig("week-menu"), this.player, n);
                this.menuFactory.getOpenMenus().put(this.player.getUniqueId(), weekMenu);
                weekMenu.show();
            }
        }).build();
    }

    @Override
    public ImmutablePair<Collection<Integer>, Collection<Integer>> elementalValues() {
        return ImmutablePair.of((Collection)IntStream.range(1, this.questCache.getMaxWeek() + 1).boxed().collect(Collectors.toSet()), MenuService.parseSlots(this, this.config, "week-slots"));
    }

    @Override
    public boolean isUserViable() {
        return this.user != null;
    }
}

