/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.menus.menus.rewards;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.api.BattlePassApi;
import io.github.battlepass.cache.RewardCache;
import io.github.battlepass.loader.PassLoader;
import io.github.battlepass.menus.PageMethods;
import io.github.battlepass.menus.UserDependent;
import io.github.battlepass.menus.service.extensions.ConfigMenu;
import io.github.battlepass.objects.pass.Tier;
import io.github.battlepass.objects.user.User;
import io.github.battlepass.quests.workers.reset.DailyQuestReset;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import me.hyfe.simplespigot.config.Config;
import me.hyfe.simplespigot.menu.item.MenuItem;
import me.hyfe.simplespigot.menu.service.MenuService;
import me.hyfe.simplespigot.tuple.MutablePair;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class SingleItemRewardsMenu
extends ConfigMenu
implements PageMethods,
UserDependent {
    private final BattlePassApi api;
    private final PassLoader passLoader;
    private final RewardCache rewardCache;
    private final DailyQuestReset dailyQuestReset;
    private final List<Integer> rewardSlots;
    private final Map<Integer, Set<Integer>> cachedPageIndexes = Maps.newHashMap();
    private final boolean autoReceiveRewards;
    private final User user;
    private int page = 1;

    public SingleItemRewardsMenu(BattlePlugin battlePlugin, Config config, Player player) {
        super(battlePlugin, config, player);
        this.api = battlePlugin.getLocalApi();
        this.passLoader = battlePlugin.getPassLoader();
        this.rewardCache = battlePlugin.getRewardCache();
        this.dailyQuestReset = battlePlugin.getDailyQuestReset();
        this.rewardSlots = Lists.newArrayList(MenuService.parseSlots(this, this.config, "reward-slots"));
        this.autoReceiveRewards = this.plugin.getConfig("settings").bool("current-season.auto-receive-rewards");
        this.user = battlePlugin.getUserCache().getOrThrow(player.getUniqueId());
    }

    @Override
    public void redraw() {
        this.computeAndDrawRewards(() -> this.drawConfigItems(replacer -> replacer.set("daily_time_left", this.dailyQuestReset.asString())));
    }

    @Override
    public void nextPage(Runnable runnable) {
        int n = Math.max(this.passLoader.passTypeOfId("free").getTiers().lastKey(), this.passLoader.passTypeOfId("premium").getTiers().lastKey());
        if (n >= this.rewardSlots.size() * this.page + 1) {
            ++this.page;
            runnable.run();
        }
    }

    @Override
    public void previousPage(Runnable runnable) {
        --this.page;
        runnable.run();
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public boolean isUserViable() {
        return this.user != null;
    }

    public void computeAndDrawRewards(Runnable runnable) {
        TreeMap treeMap = Maps.newTreeMap();
        for (Map.Entry<Integer, Tier> entry : this.passLoader.passTypeOfId("free").getTiers().entrySet()) {
            treeMap.put(entry.getKey(), MutablePair.of(entry.getValue(), null));
        }
        for (Map.Entry<Integer, Tier> entry : this.passLoader.passTypeOfId("premium").getTiers().entrySet()) {
            if (treeMap.containsKey(entry.getKey())) {
                ((MutablePair)treeMap.get(entry.getKey())).setValue(entry.getValue());
                continue;
            }
            treeMap.put(entry.getKey(), MutablePair.of(null, entry.getValue()));
        }
        this.cachedPageIndexes.computeIfAbsent(this.page, n -> {
            LinkedHashSet linkedHashSet = Sets.newLinkedHashSetWithExpectedSize((int)this.rewardSlots.size());
            for (int i = 0; i < this.rewardSlots.size(); ++i) {
                int n2 = (this.page - 1) * this.rewardSlots.size() + i + 1;
                if (!treeMap.containsKey(n2)) continue;
                linkedHashSet.add(n2);
            }
            return linkedHashSet;
        });
        Iterator<Object> iterator = this.rewardSlots.iterator();
        while (iterator.hasNext()) {
            int n2 = (Integer)iterator.next();
            this.flush(n2);
        }
        runnable.run();
        iterator = this.cachedPageIndexes.get(this.page).iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            MutablePair mutablePair = (MutablePair)treeMap.get(n3);
            int n4 = ((Tier)mutablePair.getKey()).getTier();
            boolean bl = this.user.hasPendingTier("premium", n4);
            boolean bl2 = this.user.hasPendingTier("free", n4);
            this.item(MenuItem.builderOf(this.getTierItem(mutablePair, bl, bl2)).rawSlot(this.rewardSlots.get(n3 - (this.rewardSlots.size() * (this.page - 1) + 1))).onClick((menuItem, clickType) -> {
                if (!this.autoReceiveRewards && (bl2 || bl)) {
                    if (bl) {
                        this.api.reward(this.user, "premium", n4, true);
                        this.user.getPendingTiers("premium").remove(n4);
                    }
                    if (bl2) {
                        this.api.reward(this.user, "free", n4, true);
                        this.user.getPendingTiers("free").remove(n4);
                    }
                    this.redraw();
                }
            }).build());
        }
    }

    private ItemStack getTierItem(MutablePair<Tier, Tier> mutablePair, boolean bl, boolean bl2) {
        return null;
    }
}

