/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.objects.quests;

import com.google.common.collect.Maps;
import java.math.BigInteger;
import java.util.Map;
import java.util.Set;
import me.hyfe.simplespigot.annotations.Nullable;
import me.hyfe.simplespigot.config.Config;
import net.advancedplugins.bp.impl.actions.objects.variable.Variable;
import org.bukkit.inventory.ItemStack;

public class Quest {
    private final String id;
    private final String categoryId;
    private final String name;
    private final String type;
    private final BigInteger requiredProgress;
    private final Variable variable;
    private final int points;
    private final Map<BigInteger, Integer> notifyAt = Maps.newHashMap();
    private final Set<String> whitelistedWorlds;
    private final Set<String> blacklistedWorlds;
    private final Set<String> whitelistedRegions;
    private final Set<String> blacklistedRegions;
    private final String exclusiveTo;
    private final boolean antiAbuse;
    private ItemStack itemStack;
    private Config config;

    public Quest(String string, String string2, String string3, ItemStack itemStack, String string4, BigInteger bigInteger, Variable variable, int n, Set<Integer> set, Set<String> set2, Set<String> set3, Set<String> set4, Set<String> set5, @Nullable String string5, boolean bl, Config config) {
        this.id = string;
        this.categoryId = string2;
        this.name = string3;
        this.itemStack = itemStack;
        this.type = string4;
        this.requiredProgress = bigInteger;
        this.variable = variable;
        this.points = n;
        this.whitelistedWorlds = set2;
        this.blacklistedWorlds = set3;
        this.whitelistedRegions = set4;
        this.blacklistedRegions = set5;
        this.exclusiveTo = string5;
        this.antiAbuse = bl;
        this.config = config;
        for (int n2 : set) {
            this.notifyAt.put(this.requiredProgress.multiply(BigInteger.valueOf(n2)).divide(BigInteger.valueOf(100L)), n2);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    public BigInteger getRequiredProgress() {
        return this.requiredProgress;
    }

    public Variable getVariable() {
        return this.variable;
    }

    public int getPoints() {
        return this.points;
    }

    public Map<BigInteger, Integer> getNotifyAt() {
        return this.notifyAt;
    }

    public Set<String> getWhitelistedWorlds() {
        return this.whitelistedWorlds;
    }

    public Set<String> getBlacklistedWorlds() {
        return this.blacklistedWorlds;
    }

    public Set<String> getWhitelistedRegions() {
        return this.whitelistedRegions;
    }

    public Set<String> getBlacklistedRegions() {
        return this.blacklistedRegions;
    }

    public String getExclusiveTo() {
        return this.exclusiveTo;
    }

    public boolean isAntiAbuse() {
        return this.antiAbuse;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    public Config getConfig() {
        return this.config;
    }
}

