/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.quests.workers.pipeline;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.cache.QuestCache;
import io.github.battlepass.cache.UserCache;
import io.github.battlepass.logger.DebugLogger;
import io.github.battlepass.logger.containers.LogContainer;
import io.github.battlepass.quests.workers.pipeline.steps.QuestValidationStep;
import java.math.BigInteger;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import me.hyfe.simplespigot.text.replacer.Replacer;
import net.advancedplugins.bp.impl.actions.ActionExecution;
import net.advancedplugins.bp.impl.actions.objects.variable.ActionResult;
import net.advancedplugins.bp.impl.actions.objects.variable.ExecutableActionResult;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class QuestPipeline {
    private final QuestValidationStep questValidationStep;
    private final DebugLogger logger;
    private final UserCache userCache;
    private final QuestCache questCache;
    private final boolean banPermissionEnabled;

    public QuestPipeline(BattlePlugin battlePlugin) {
        this.questValidationStep = new QuestValidationStep(battlePlugin);
        this.logger = battlePlugin.getDebugLogger();
        this.userCache = battlePlugin.getUserCache();
        this.questCache = battlePlugin.getQuestCache();
        this.banPermissionEnabled = battlePlugin.getConfig("settings").bool("enable-ban-permission");
    }

    @Deprecated
    public void handle(String string, Player player, int n, ActionResult actionResult, Replacer replacer, boolean bl) {
        this.handle(new ActionExecution(player, string, BigInteger.valueOf(n), bl, (ExecutableActionResult)actionResult));
    }

    public void handle(ActionExecution actionExecution) {
        Player player = actionExecution.getPlayer();
        if (this.banPermissionEnabled && player.hasPermission("battlepass.block") && !player.hasPermission("battlepass.admin")) {
            this.logger.log(LogContainer.of("(PIPELINE) Player %battlepass-player% is blocked from the battlepass so dropping them.", player));
            return;
        }
        if (Bukkit.getPlayer((String)player.getName()) == null || player.isDead() || !player.isValid()) {
            return;
        }
        ((CompletableFuture)this.userCache.get(player.getUniqueId()).thenAcceptAsync(optional -> optional.ifPresent(user -> {
            actionExecution.setUser(user);
            this.questValidationStep.processCompletion(actionExecution, this.questCache.getAllQuests());
        }), (Executor)this.userCache.getExecutorService())).exceptionally(throwable -> {
            this.logger.log("(PIPELINE) Generic Error ".concat(throwable.getMessage()));
            throwable.printStackTrace();
            return null;
        });
    }
}

