/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.quests.workers.pipeline.steps;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.actions.Action;
import io.github.battlepass.lang.Lang;
import io.github.battlepass.objects.quests.Quest;
import io.github.battlepass.objects.user.User;
import io.github.battlepass.quests.workers.pipeline.steps.RewardStep;
import io.github.battlepass.service.Services;
import io.github.battlepass.service.bossbar.BossBar;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import me.hyfe.simplespigot.config.Config;
import me.hyfe.simplespigot.text.Text;
import me.hyfe.simplespigot.text.replacer.Replacer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;

public class NotificationStep
implements Listener {
    private final List<Action> completionActions = Lists.newArrayList();
    private final Map<UUID, BossBar> bossBars = Maps.newConcurrentMap();
    private final RewardStep rewardStep;
    private final BattlePlugin plugin;
    private final Lang lang;
    private final String notificationMethod;
    private final boolean bossBarEnabled;
    private final boolean useNotifyPercentages;
    private final int bossBarLength;
    private final Set<String> disabledBossQuests;

    public NotificationStep(BattlePlugin battlePlugin) {
        Config config = battlePlugin.getConfig("settings");
        this.completionActions.addAll(config.stringList("quest-completed-actions").stream().map(Action::parse).collect(Collectors.toList()));
        this.notificationMethod = config.string("current-season.notification-method");
        this.bossBarEnabled = config.bool("boss-bar.enabled");
        this.useNotifyPercentages = config.bool("boss-bar.use-notify-percentages");
        this.bossBarLength = this.bossBarEnabled ? (config.bool("boss-bar.persistent") ? 0x3FFFFFFF : config.integer("boss-bar.hide-after")) : -1;
        this.disabledBossQuests = Sets.newHashSet(config.stringList("boss-bar.disabled-quest-types"));
        this.plugin = battlePlugin;
        this.lang = battlePlugin.getLang();
        this.rewardStep = new RewardStep(battlePlugin);
        this.plugin.registerListeners(this);
    }

    public void process(Player player, User user, Quest quest, BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger.compareTo(bigInteger2) == 0) {
            return;
        }
        if (bigInteger2.compareTo(quest.getRequiredProgress()) > -1) {
            this.plugin.runSync(() -> Action.executeSimple(player, this.completionActions, this.plugin, new Replacer().set("player", player.getName()).set("quest_name", quest.getName()).set("quest_category", quest.getCategoryId())));
            this.sendBossBarIfEnabled(player, quest, 100.0, bigInteger2, true);
            String string = this.lang.questCompleteMessage(quest);
            if (this.notificationMethod.contains("chat")) {
                Text.sendMessage((CommandSender)player, string);
            }
            if (this.notificationMethod.contains("action bar")) {
                Services.sendActionBar(player, string);
            }
            this.rewardStep.process(user, quest);
        } else {
            if (!this.useNotifyPercentages) {
                double d = Services.getPercentage(bigInteger2, quest.getRequiredProgress()).doubleValue();
                this.sendBossBarIfEnabled(player, quest, d, bigInteger2, false);
            }
            for (BigInteger bigInteger3 : quest.getNotifyAt().keySet()) {
                int n = bigInteger2.compareTo(bigInteger3);
                if (n != 0 && (bigInteger3.compareTo(bigInteger) <= 0 || n <= -1)) continue;
                String string = this.lang.questProgressedMessage(quest, bigInteger2);
                if (this.useNotifyPercentages) {
                    this.sendBossBarIfEnabled(player, quest, quest.getNotifyAt().get(bigInteger3).intValue(), bigInteger2, false);
                }
                if (this.notificationMethod.contains("chat")) {
                    Text.sendMessage((CommandSender)player, string);
                }
                if (!this.notificationMethod.contains("action bar")) break;
                Services.sendActionBar(player, string);
                break;
            }
        }
    }

    private void sendBossBarIfEnabled(Player player, Quest quest, double d, BigInteger bigInteger, boolean bl) {
        if (!this.bossBarEnabled || this.disabledBossQuests.contains(quest.getType())) {
            return;
        }
        String string = bl ? this.lang.questBossCompleteMessage(quest) : this.lang.questBossProgressedMessage(quest, bigInteger);
        BossBar bossBar = this.bossBars.get(player.getUniqueId());
        if (bossBar == null) {
            bossBar = BossBar.Builder.create(this.plugin, player, string);
            this.bossBars.put(player.getUniqueId(), bossBar);
        } else {
            bossBar.setTitle(string);
        }
        bossBar.setProgress(d);
        bossBar.schedule(this.bossBarLength);
    }

    @EventHandler(ignoreCancelled=true)
    public void onQuit(PlayerQuitEvent playerQuitEvent) {
        this.bossBars.remove(playerQuitEvent.getPlayer().getUniqueId());
    }
}

