/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.quests.workers.reset;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.api.BattlePassApi;
import io.github.battlepass.api.events.server.DailyQuestsRefreshEvent;
import io.github.battlepass.cache.QuestCache;
import io.github.battlepass.cache.UserCache;
import io.github.battlepass.enums.Category;
import io.github.battlepass.lang.Lang;
import io.github.battlepass.objects.quests.Quest;
import io.github.battlepass.validator.DailyQuestValidator;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.hyfe.simplespigot.config.Config;
import me.hyfe.simplespigot.service.simple.Simple;
import me.hyfe.simplespigot.service.simple.services.TimeService;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class DailyQuestReset {
    private final TimeService.SimpleTimeFormat timeFormat;
    private final BattlePlugin plugin;
    private final BattlePassApi api;
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final int amount;
    private final ZoneId timeZone;
    private BukkitRunnable resetTask;
    private ZonedDateTime resetTime;
    protected final QuestCache questCache;
    protected final UserCache userCache;
    protected LinkedList<Quest> currentQuests;
    protected Set<Quest> permanentQuests;
    protected List<Quest> availableQuests;

    public DailyQuestReset(BattlePlugin battlePlugin, LinkedList<Quest> linkedList) {
        DailyQuestValidator dailyQuestValidator = battlePlugin.getDailyQuestValidator();
        Config config = battlePlugin.getConfig("settings");
        this.plugin = battlePlugin;
        this.timeFormat = this.createTimeFormat(battlePlugin.getLang());
        this.api = battlePlugin.getLocalApi();
        this.questCache = battlePlugin.getQuestCache();
        this.userCache = battlePlugin.getUserCache();
        this.amount = config.integer("current-season.daily-quest-amount");
        this.timeZone = ZoneId.of(config.string("current-season.time-zone"));
        this.resetTime = this.parseTime(this.now().withSecond(0), config.string("current-season.daily-quest-reset-time"));
        this.currentQuests = linkedList;
        this.permanentQuests = config.stringList("permanent-daily-quest-ids").stream().map(string -> this.questCache.getQuest(Category.DAILY.id(), (String)string)).filter(dailyQuestValidator::checkQuest).collect(Collectors.toSet());
        this.availableQuests = this.questCache.getQuests(Category.DAILY.id()).values().stream().filter(quest -> !this.permanentQuests.contains(quest)).collect(Collectors.toList());
    }

    public LinkedList<Quest> getCurrentQuests() {
        return this.currentQuests;
    }

    public void start() {
        if (this.shouldNotDoDailyQuests()) {
            this.plugin.getLogger().warning("Daily quests reset is set disabled.");
            this.currentQuests.clear();
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            this.reset();
            this.start();
            Bukkit.getOnlinePlayers().forEach(player -> this.tryResetForUser(player.getUniqueId()));
        }, this.timeToResetSeconds() * 20L);
    }

    private void tryResetForUser(UUID uUID) {
        Player player = Bukkit.getPlayer((UUID)uUID);
        if (player != null && player.isOnline()) {
            this.plugin.getLang().external("daily-quest-reset").to((CommandSender)player);
        }
    }

    public void stop() {
        if (this.resetTask != null) {
            this.resetTask.cancel();
        }
    }

    public void reset() {
        if (this.shouldNotDoDailyQuests()) {
            this.currentQuests.clear();
            return;
        }
        this.userCache.asyncModifyAll(user -> user.getQuestStore().asMap().put(Category.DAILY.id(), new ConcurrentHashMap()));
        this.currentQuests = new LinkedList<Quest>(this.permanentQuests);
        int n = Math.min(this.availableQuests.size(), this.amount - this.permanentQuests.size());
        int n2 = 0;
        Collections.shuffle(this.availableQuests);
        for (Quest quest : this.availableQuests) {
            if (n2 >= n) break;
            this.currentQuests.add(quest);
            ++n2;
        }
        Bukkit.getPluginManager().callEvent((Event)new DailyQuestsRefreshEvent(this.currentQuests));
    }

    public long timeToResetSeconds() {
        if (this.now().until(this.resetTime, ChronoUnit.SECONDS) <= 0L) {
            this.resetTime = this.resetTime.plusDays(1L);
        }
        return this.now().until(this.resetTime, ChronoUnit.SECONDS);
    }

    public String asString() {
        TimeService timeService = Simple.time();
        long l = this.timeToResetSeconds();
        return this.timeFormat == null ? timeService.format(TimeUnit.SECONDS, l) : timeService.format(this.timeFormat, TimeUnit.SECONDS, l);
    }

    private boolean shouldNotDoDailyQuests() {
        Config config = this.plugin.getConfig("settings");
        String string = "season-finished.stop-daily-quests";
        return !this.plugin.areDailyQuestsEnabled() || this.api.hasSeasonEnded() && config.has(string) && config.bool(string);
    }

    private ZonedDateTime now() {
        return ZonedDateTime.now().withZoneSameInstant(this.timeZone);
    }

    private ZonedDateTime parseTime(ZonedDateTime zonedDateTime, String string) {
        String[] stringArray = string.split(":");
        return zonedDateTime.withHour(StringUtils.isNumeric((String)stringArray[0]) ? Integer.parseInt(stringArray[0]) : 0).withMinute(stringArray.length > 1 ? (StringUtils.isNumeric((String)stringArray[1]) ? Integer.parseInt(stringArray[1]) : 0) : 0);
    }

    private TimeService.SimpleTimeFormat createTimeFormat(Lang lang) {
        return lang.has("daily-quest-time-format") ? new TimeService.SimpleTimeFormat(null, lang.external("daily-quest-time-format.with-months-weeks").toString(), lang.external("daily-quest-time-format.with-weeks-days").toString(), lang.external("daily-quest-time-format.with-days-hours").toString(), lang.external("daily-quest-time-format.with-hours-minutes").toString(), lang.external("daily-quest-time-format.with-minutes-seconds").toString(), lang.external("daily-quest-time-format.with-seconds").toString()) : null;
    }
}

