/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.registry;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.cache.UserCache;
import io.github.battlepass.objects.user.User;
import java.math.BigInteger;
import java.util.Optional;
import me.hyfe.simplespigot.command.CommandBase;
import me.hyfe.simplespigot.registry.Registry;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ArgumentRegistry
implements Registry {
    private final CommandBase commandBase;
    private final UserCache userCache;

    public ArgumentRegistry(BattlePlugin battlePlugin) {
        this.commandBase = battlePlugin.getCommandBase();
        this.userCache = battlePlugin.getUserCache();
    }

    @Override
    public void register() {
        this.commandBase.registerArgumentType(User.class, string -> {
            Player player = Bukkit.getPlayerExact((String)string);
            return player == null ? Optional.empty() : this.userCache.getSync(player.getUniqueId());
        }).registerArgumentType(BigInteger.class, string -> {
            try {
                return new BigInteger(string);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        });
    }
}

