/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.service.bossbar;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.service.bossbar.BossBar;
import me.hyfe.simplespigot.config.Config;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class NewBossBar
implements BossBar {
    private final org.bukkit.boss.BossBar bossBar;
    private final BattlePlugin plugin;
    private BukkitTask bukkitTask;

    public NewBossBar(BattlePlugin battlePlugin, Player player, String string) {
        this.plugin = battlePlugin;
        Config config = battlePlugin.getConfig("settings");
        this.bossBar = Bukkit.createBossBar((String)string, (BarColor)BarColor.valueOf((String)config.string("boss-bar.color")), (BarStyle)BarStyle.valueOf((String)config.string("boss-bar.style")), (BarFlag[])new BarFlag[0]);
        this.bossBar.setVisible(false);
        this.bossBar.addPlayer(player);
    }

    @Override
    public void show() {
        this.bossBar.setVisible(true);
    }

    @Override
    public void hide() {
        this.bossBar.setVisible(false);
    }

    @Override
    public void setTitle(String string) {
        this.bossBar.setTitle(string);
    }

    @Override
    public void setProgress(double d) {
        this.bossBar.setProgress(d / 100.0);
    }

    @Override
    public void schedule(int n) {
        this.endDisplay();
        this.show();
        this.bukkitTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::endDisplay, (long)(n * 20));
    }

    @Override
    public void endDisplay() {
        if (this.bukkitTask == null) {
            return;
        }
        this.bukkitTask.cancel();
        this.bukkitTask = null;
        this.hide();
    }
}

