/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.service.bossbar;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.service.bossbar.BossBar;
import net.minecraft.server.v1_8_R3.EntityLiving;
import net.minecraft.server.v1_8_R3.EntityWither;
import net.minecraft.server.v1_8_R3.Packet;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityDestroy;
import net.minecraft.server.v1_8_R3.PacketPlayOutEntityMetadata;
import net.minecraft.server.v1_8_R3.PacketPlayOutSpawnEntityLiving;
import net.minecraft.server.v1_8_R3.World;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.craftbukkit.v1_8_R3.CraftWorld;
import org.bukkit.craftbukkit.v1_8_R3.entity.CraftPlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class OldBossBar
implements BossBar {
    private final BattlePlugin plugin;
    private final Player player;
    private final EntityWither wither;
    private String title;
    private BukkitTask bukkitTask;
    private boolean isShown;

    public OldBossBar(BattlePlugin battlePlugin, Player player, String string) {
        this.plugin = battlePlugin;
        this.player = player;
        this.title = string;
        this.wither = this.create();
    }

    private EntityWither create() {
        EntityWither entityWither = new EntityWither((World)((CraftWorld)this.player.getWorld()).getHandle());
        Location location = this.getWitherLocation(this.player.getLocation());
        entityWither.setCustomName(this.title);
        entityWither.setInvisible(true);
        entityWither.setLocation(location.getX(), location.getY(), location.getZ(), 0.0f, 0.0f);
        return entityWither;
    }

    @Override
    public void show() {
        this.isShown = true;
        PacketPlayOutSpawnEntityLiving packetPlayOutSpawnEntityLiving = new PacketPlayOutSpawnEntityLiving((EntityLiving)this.wither);
        ((CraftPlayer)this.player).getHandle().playerConnection.sendPacket((Packet)packetPlayOutSpawnEntityLiving);
    }

    @Override
    public void hide() {
        this.isShown = false;
        PacketPlayOutEntityDestroy packetPlayOutEntityDestroy = new PacketPlayOutEntityDestroy(new int[]{this.wither.getId()});
        ((CraftPlayer)this.player).getHandle().playerConnection.sendPacket((Packet)packetPlayOutEntityDestroy);
    }

    @Override
    public void setTitle(String string) {
        this.title = string;
        this.wither.setCustomName(string);
        if (this.isShown) {
            PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = new PacketPlayOutEntityMetadata(this.wither.getId(), this.wither.getDataWatcher(), true);
            ((CraftPlayer)this.player).getHandle().playerConnection.sendPacket((Packet)packetPlayOutEntityMetadata);
        }
    }

    @Override
    public void setProgress(double d) {
        this.wither.setHealth((float)(d / 100.0 * (double)this.wither.getMaxHealth()));
        if (this.isShown) {
            PacketPlayOutEntityMetadata packetPlayOutEntityMetadata = new PacketPlayOutEntityMetadata(this.wither.getId(), this.wither.getDataWatcher(), true);
            ((CraftPlayer)this.player).getHandle().playerConnection.sendPacket((Packet)packetPlayOutEntityMetadata);
        }
    }

    private Location getWitherLocation(Location location) {
        return location.add(location.getDirection().multiply(60));
    }

    @Override
    public void schedule(int n) {
        this.endDisplay();
        this.show();
        this.bukkitTask = Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, this::endDisplay, (long)(n * 20));
    }

    @Override
    public void endDisplay() {
        if (this.bukkitTask == null) {
            return;
        }
        this.bukkitTask.cancel();
        this.bukkitTask = null;
        this.hide();
    }
}

