/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.storage;

import com.google.gson.reflect.TypeToken;
import io.github.battlepass.BattlePlugin;
import io.github.battlepass.objects.user.QuestStore;
import io.github.battlepass.objects.user.User;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.UUID;
import java.util.logging.Level;
import me.hyfe.simplespigot.storage.storage.Storage;
import me.hyfe.simplespigot.storage.storage.load.Deserializer;
import me.hyfe.simplespigot.storage.storage.load.Serializer;
import me.hyfe.simplespigot.uuid.FastUuid;
import org.bukkit.Bukkit;

public class UserStorage
extends Storage<User> {
    public UserStorage(BattlePlugin battlePlugin) {
        super(battlePlugin, backendFactory -> backendFactory.create(battlePlugin.getConfigStore().commons().get("storage-type"), path -> path.resolve("users"), ""));
    }

    @Override
    public Serializer<User> serializer() {
        return (user, jsonObject, gson) -> {
            jsonObject.addProperty("uuid", FastUuid.toString(user.getUuid()));
            jsonObject.addProperty("quests", gson.toJson((Object)user.getQuestStore()));
            jsonObject.addProperty("pass-id", user.getPassId());
            jsonObject.addProperty("tier", (Number)user.getTier());
            jsonObject.addProperty("points", user.getPoints().toString());
            jsonObject.addProperty("currency", user.getCurrency().toString());
            jsonObject.addProperty("bypass-locked-weeks", Boolean.valueOf(user.bypassesLockedWeeks()));
            jsonObject.addProperty("pending-rewards", gson.toJson(user.getPendingTiers()));
            return jsonObject;
        };
    }

    @Override
    public Deserializer<User> deserializer() {
        return (jsonObject, gson) -> {
            UUID uUID = FastUuid.parse(jsonObject.get("uuid").getAsString());
            try {
                QuestStore questStore = (QuestStore)gson.fromJson(jsonObject.get("quests").getAsString(), QuestStore.class);
                String string = jsonObject.get("pass-id").getAsString();
                int n = jsonObject.get("tier").getAsInt();
                BigInteger bigInteger = new BigInteger(jsonObject.get("points").getAsString());
                BigInteger bigInteger2 = jsonObject.has("currency") ? new BigInteger(jsonObject.get("currency").getAsString()) : BigInteger.ZERO;
                boolean bl = jsonObject.has("bypass-locked-weeks") && jsonObject.get("bypass-locked-weeks").getAsBoolean();
                Map map = (Map)gson.fromJson(jsonObject.get("pending-rewards").getAsString(), new TypeToken<HashMap<String, TreeSet<Integer>>>(){}.getType());
                return new User(uUID, questStore, n, bigInteger, bigInteger2, string, bl, map);
            }
            catch (Exception exception) {
                Bukkit.getLogger().log(Level.SEVERE, "Error whilst loading player data file: " + uUID + ".json", exception);
                return null;
            }
        };
    }
}

