/*
 * Decompiled with CFR 0.152.
 */
package io.github.battlepass.validator;

import io.github.battlepass.BattlePlugin;
import io.github.battlepass.objects.quests.Quest;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class QuestValidator {
    private final Logger logger = BattlePlugin.logger();

    public boolean checkQuest(Quest quest, AtomicInteger atomicInteger) {
        String string = "[Quest Validator] You have a broken quest. ";
        if (this.checkQuest(string, quest, atomicInteger)) {
            return false;
        }
        return !this.checkName(string = string + " Category: " + quest.getCategoryId() + " | ID: " + quest.getId() + " | ", quest, atomicInteger) && !this.checkType(string, quest, atomicInteger) && !this.checkRequiredProgress(string, quest, atomicInteger) && !this.checkPoints(string, quest, atomicInteger) && !this.checkItemStack(string, quest, atomicInteger);
    }

    private boolean checkQuest(String string, Quest quest, AtomicInteger atomicInteger) {
        if (quest == null) {
            this.logger.severe(string.concat("Quest itself is null."));
            atomicInteger.getAndIncrement();
            return true;
        }
        return false;
    }

    private boolean checkName(String string, Quest quest, AtomicInteger atomicInteger) {
        if (quest.getName() == null || quest.getName().replace(" ", "").isEmpty()) {
            this.log(string.concat("This quest has no name."));
            atomicInteger.getAndIncrement();
            return true;
        }
        return false;
    }

    private boolean checkType(String string, Quest quest, AtomicInteger atomicInteger) {
        if (quest.getType() == null || quest.getType().replace(" ", "").isEmpty()) {
            this.log(string.concat("This quest has no type (e.g block-break or block-place)."));
            atomicInteger.getAndIncrement();
            return true;
        }
        return false;
    }

    private boolean checkRequiredProgress(String string, Quest quest, AtomicInteger atomicInteger) {
        if (quest.getRequiredProgress().compareTo(BigInteger.ONE) < 0) {
            this.log(string.concat("This quest's progress is not set or is lower than 1."));
            atomicInteger.getAndIncrement();
            return true;
        }
        return false;
    }

    private boolean checkPoints(String string, Quest quest, AtomicInteger atomicInteger) {
        if (quest.getPoints() < 1) {
            this.log(string.concat("This quest's points reward is not set or is lower than one."));
            atomicInteger.getAndIncrement();
            return true;
        }
        return false;
    }

    private boolean checkItemStack(String string, Quest quest, AtomicInteger atomicInteger) {
        if (quest.getItemStack() == null) {
            this.log(string.concat("This quest's item is not present or is broken."));
            quest.setItemStack(new ItemStack(Material.BARRIER));
            atomicInteger.getAndIncrement();
            return true;
        }
        return false;
    }

    private void log(String string) {
        this.logger.warning(string);
    }
}

