/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Collection;
import java.util.Set;
import java.util.function.UnaryOperator;

public class CacheWrapper<K, V> {
    protected final Cache<K, V> subCache;

    public CacheWrapper() {
        this.subCache = CacheBuilder.newBuilder().build();
    }

    public CacheWrapper(UnaryOperator<CacheBuilder<Object, Object>> unaryOperator) {
        this.subCache = ((CacheBuilder)unaryOperator.apply(CacheBuilder.newBuilder())).build();
    }

    public Cache<K, V> getSubCache() {
        return this.subCache;
    }

    public V set(K k, V v) {
        this.subCache.put(k, v);
        return v;
    }

    public void invalidate(K k) {
        this.subCache.invalidate(k);
    }

    public Set<K> keySet() {
        return this.subCache.asMap().keySet();
    }

    public Collection<V> values() {
        return this.subCache.asMap().values();
    }

    public boolean hasKey(K k) {
        return this.subCache.asMap().containsKey(k);
    }

    public boolean hasValue(V v) {
        return this.subCache.asMap().containsValue(v);
    }
}

