/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.command.command;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import me.hyfe.simplespigot.command.argument.Argument;
import me.hyfe.simplespigot.command.argument.ArgumentHandler;
import me.hyfe.simplespigot.command.command.Command;
import me.hyfe.simplespigot.plugin.SimplePlugin;
import org.bukkit.command.CommandSender;

public abstract class SubCommand<T extends CommandSender>
extends Command<T> {
    private final boolean endless;
    private List<Argument<?>> arguments = Lists.newArrayList();
    private boolean inheritPermission;

    public SubCommand(SimplePlugin simplePlugin, String string, boolean bl) {
        this(simplePlugin, string, bl, false);
    }

    public SubCommand(SimplePlugin simplePlugin, String string, boolean bl, boolean bl2) {
        super(simplePlugin, string, bl);
        this.endless = bl2;
    }

    public SubCommand(SimplePlugin simplePlugin) {
        this(simplePlugin, "", true);
    }

    public SubCommand(SimplePlugin simplePlugin, String string) {
        this(simplePlugin, string, true);
    }

    public SubCommand(SimplePlugin simplePlugin, boolean bl) {
        this(simplePlugin, "", bl);
    }

    protected void inheritPermission() {
        this.inheritPermission = true;
    }

    public boolean doesInheritPermission() {
        return this.inheritPermission;
    }

    public boolean isEndless() {
        return this.endless;
    }

    public void setArguments(List<Argument<?>> list) {
        this.arguments = list;
    }

    public void addFlat(String string) {
        this.arguments.add(new Argument(null, string, new String[0]));
    }

    public void addFlatWithAliases(String string, String ... stringArray) {
        this.arguments.add(new Argument(null, string, stringArray));
    }

    public void addFlats(String ... stringArray) {
        for (String string : stringArray) {
            this.addFlat(string);
        }
    }

    protected <S> void addArgument(Class<S> clazz, String string, String ... stringArray) {
        this.arguments.add(new Argument(ArgumentHandler.getArgumentType(clazz), string, stringArray));
    }

    protected <S> void addArgument(Class<S> clazz, String string, Function<CommandSender, List<String>> function, String ... stringArray) {
        this.arguments.add(new Argument(ArgumentHandler.getArgumentType(clazz), string, function, stringArray));
    }

    public int getArgumentsSize() {
        return this.arguments.size();
    }

    public <U> U parseArgument(String[] stringArray, int n) {
        return (U)this.arguments.get(n).getType().parse(stringArray[n]);
    }

    public boolean isMatch(String[] stringArray) {
        return this.isMatchUntilIndex(stringArray, stringArray.length);
    }

    public String[] getEnd(String[] stringArray) {
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i < this.arguments.size() - 1) continue;
            linkedHashSet.add(stringArray[i]);
        }
        return linkedHashSet.toArray(new String[0]);
    }

    public boolean isMatchUntilIndex(String[] stringArray, int n) {
        for (int i = 0; i < n; ++i) {
            if (this.isArgumentValid(stringArray, i)) continue;
            return false;
        }
        return true;
    }

    public List<String> tabCompletionSuggestion(CommandSender commandSender, int n) {
        if (n > this.arguments.size() - 1) {
            return Lists.newArrayList();
        }
        return this.arguments.get(n).getOnTabComplete().apply(commandSender);
    }

    private boolean isArgumentValid(String[] stringArray, int n) {
        if (this.arguments.size() - 1 < n && this.endless) {
            return true;
        }
        if (this.arguments.size() - 1 < n) {
            return false;
        }
        Argument<?> argument = this.arguments.get(n);
        if (argument.getType() == null) {
            String string = stringArray[n];
            for (String string2 : argument.getAliases()) {
                if (!string.equalsIgnoreCase(string2)) continue;
                return true;
            }
            return stringArray[n].equalsIgnoreCase(argument.getArgument());
        }
        return true;
    }
}

