/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.config;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import me.hyfe.simplespigot.text.Text;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;

public class Config {
    private final Plugin plugin;
    private final File file;
    private final boolean reloadable;
    private YamlConfiguration configuration;
    private Map<String, Object> valueMap;
    private Set<String> enduringKeys;

    public Config(Plugin plugin, UnaryOperator<Path> unaryOperator, boolean bl, String ... stringArray) {
        this.plugin = plugin;
        this.file = ((Path)unaryOperator.apply(plugin.getDataFolder().toPath())).toFile();
        this.reloadable = bl;
        this.enduringKeys = Sets.newHashSet((Object[])stringArray);
        this.createIfAbsent(((Path)unaryOperator.apply(Paths.get("", new String[0]))).toString());
        this.reload();
        this.load();
    }

    public Config(Plugin plugin, File file, boolean bl, String ... stringArray) {
        this.plugin = plugin;
        this.file = file;
        this.reloadable = bl;
        this.enduringKeys = Sets.newHashSet((Object[])stringArray);
        this.reload();
        this.load();
    }

    public YamlConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean isReloadable() {
        return this.reloadable;
    }

    public boolean has(String string) {
        return this.configuration.contains(string);
    }

    public String string(String string) {
        return Text.modify((String)this.get(string));
    }

    public String forcedString(String string) {
        return Text.modify(String.valueOf(this.get(string)));
    }

    public boolean bool(String string) {
        Object object = this.get(string);
        return object instanceof Boolean ? (Boolean)object : false;
    }

    public File getFile() {
        return this.file;
    }

    public int integer(String string) {
        Object object = this.get(string);
        return object instanceof Number ? ((Number)object).intValue() : -1;
    }

    public double doubl(String string) {
        Object object = this.get(string);
        return object instanceof Number ? ((Number)object).doubleValue() : -1.0;
    }

    public List<String> stringList(String string) {
        Object object = this.get(string);
        return object instanceof List ? (List)object : Lists.newArrayList();
    }

    public <T> List<T> list(String string) {
        Object object = this.get(string);
        return object instanceof List ? (List)object : Lists.newArrayList();
    }

    public Set<String> keys(String string, boolean bl) {
        ConfigurationSection configurationSection = this.configuration.getConfigurationSection(string);
        if (configurationSection == null) {
            return null;
        }
        return configurationSection.getKeys(bl);
    }

    public Object get(String string) {
        return this.valueMap.getOrDefault(string, null);
    }

    public synchronized void load() {
        boolean bl = true;
        if (this.valueMap == null) {
            this.valueMap = Maps.newHashMap();
            bl = false;
        }
        for (String string : this.configuration.getKeys(true)) {
            if (bl && this.enduringKeys.contains(string)) continue;
            this.valueMap.put(string, this.configuration.get(string));
        }
    }

    public void reload() {
        this.configuration = YamlConfiguration.loadConfiguration((File)this.file);
        this.load();
    }

    private void createIfAbsent(String string) {
        if (!this.file.exists()) {
            this.plugin.getDataFolder().mkdirs();
            this.plugin.saveResource(string, false);
        }
    }
}

