/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.config;

import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import me.hyfe.simplespigot.config.Config;
import org.bukkit.plugin.Plugin;

public class ConfigStore {
    private final Plugin plugin;
    private Map<String, Config> configMap = Maps.newHashMap();
    private Map<String, String> commons = Maps.newHashMap();

    public ConfigStore(Plugin plugin) {
        this.plugin = plugin;
    }

    public Map<String, String> commons() {
        return this.commons;
    }

    public Config getConfig(String string) {
        return this.configMap.get(string);
    }

    public ConfigStore config(String string, BiFunction<Path, String, Path> biFunction, boolean bl) {
        this.configMap.put(string, new Config(this.plugin, path -> Paths.get(((Path)biFunction.apply((Path)path, string)).toString().concat(".yml"), new String[0]), bl, new String[0]));
        return this;
    }

    public ConfigStore common(String string, String string2, Function<Config, String> function) {
        this.commons.put(string, function.apply(this.getConfig(string2)));
        return this;
    }

    public void forceReload(String string) {
        Config config = this.getConfig(string);
        if (config != null) {
            config.reload();
        }
    }

    public void forceReload(String ... stringArray) {
        for (String string : stringArray) {
            this.forceReload(string);
        }
    }

    public void reloadReloadableConfigs() {
        for (Config config : this.configMap.values()) {
            if (!config.isReloadable()) continue;
            config.reload();
        }
    }
}

