/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.menu;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.hyfe.simplespigot.menu.Menu;
import me.hyfe.simplespigot.menu.item.MenuItem;
import me.hyfe.simplespigot.tuple.ImmutablePair;
import org.bukkit.entity.Player;

public abstract class PageableMenu<T>
extends Menu {
    protected int page = 1;
    private List<T> elements;
    private List<Integer> elementSlots;
    private final Map<Integer, Set<Integer>> cachedPageIndexes = Maps.newHashMap();

    public PageableMenu(Player player, String string, int n) {
        super(player, string, n);
    }

    public abstract MenuItem pageableItem(T var1);

    public abstract ImmutablePair<Collection<T>, Collection<Integer>> elementalValues();

    @Override
    public void close() {
        this.player.closeInventory();
        this.cachedPageIndexes.clear();
    }

    public int getPage() {
        return this.page;
    }

    public void drawPageableItems() {
        this.drawPageableItems(() -> {});
    }

    public void drawPageableItems(Runnable runnable) {
        if (this.elements == null || this.elementSlots == null) {
            this.elements = Lists.newArrayList((Iterable)this.elementalValues().getKey());
            this.elementSlots = Lists.newArrayList((Iterable)this.elementalValues().getValue());
        }
        this.cachedPageIndexes.computeIfAbsent(this.page, n -> {
            int n2 = this.elementSlots.size();
            LinkedHashSet linkedHashSet = Sets.newLinkedHashSetWithExpectedSize((int)n2);
            for (int i = 0; i < n2; ++i) {
                int n3 = (this.page - 1) * n2 + i;
                if (n3 >= this.elements.size()) continue;
                linkedHashSet.add(n3);
            }
            return linkedHashSet;
        });
        for (int n2 : this.elementSlots) {
            this.flush(n2);
        }
        runnable.run();
        int n3 = 0;
        for (int n4 : this.cachedPageIndexes.get(this.page)) {
            this.item(MenuItem.builderOf(this.pageableItem(this.elements.get(n4))).rawSlot(this.elementSlots.get(n3)).build());
            ++n3;
        }
    }

    public void nextPage(Runnable runnable) {
        if (this.elements.size() < this.elementSlots.size() * this.page + 1) {
            return;
        }
        ++this.page;
        runnable.run();
    }

    public void previousPage(Runnable runnable) {
        --this.page;
        runnable.run();
    }

    public void refreshPageableItems() {
        this.elements = Lists.newArrayList((Iterable)this.elementalValues().getKey());
        this.cachedPageIndexes.clear();
        this.redraw();
    }
}

