/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.menu.item;

import java.util.Arrays;
import me.hyfe.simplespigot.config.Config;
import me.hyfe.simplespigot.item.SpigotItem;
import me.hyfe.simplespigot.menu.Menu;
import me.hyfe.simplespigot.menu.item.click.ClickAction;
import me.hyfe.simplespigot.text.replacer.Replace;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class MenuItem {
    private final ItemStack itemStack;
    private final int row;
    private final int slot;
    private final ClickAction clickAction;

    public MenuItem(ItemStack itemStack, int n, int n2, ClickAction clickAction) {
        this.itemStack = itemStack;
        this.hideAttributes();
        this.row = n;
        this.slot = n2;
        this.clickAction = clickAction;
    }

    private void hideAttributes() {
        ItemMeta itemMeta = this.itemStack.getItemMeta();
        if (itemMeta != null) {
            Arrays.stream(ItemFlag.values()).forEach(itemFlag -> itemMeta.addItemFlags(new ItemFlag[]{itemFlag}));
            this.itemStack.setItemMeta(itemMeta);
        }
    }

    public static MenuItem of(ItemStack itemStack) {
        return new MenuItem(itemStack, 1, 1, (menuItem, clickType) -> {});
    }

    public static Builder builderOf(ItemStack itemStack) {
        return new Builder(new MenuItem(itemStack, 1, 1, (menuItem, clickType) -> {}));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builderOf(MenuItem menuItem) {
        return new Builder(menuItem);
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public int getRow() {
        return this.row;
    }

    public int getSlot() {
        return this.slot;
    }

    public ClickAction getClickAction() {
        return this.clickAction;
    }

    public static class Builder {
        private ItemStack itemStack;
        private int slot;
        private int row;
        private ClickAction clickAction;

        public Builder() {
        }

        public Builder(MenuItem menuItem) {
            this.itemStack = menuItem.getItemStack();
            this.slot = menuItem.getSlot();
            this.row = menuItem.getRow();
            this.clickAction = menuItem.getClickAction();
        }

        public Builder item(SpigotItem.Builder builder) {
            this.itemStack = builder.build();
            return this;
        }

        public Builder item(Config config, String string) {
            this.itemStack = SpigotItem.toItem(config, string);
            return this;
        }

        public Builder item(Config config, String string, Replace replace) {
            this.itemStack = SpigotItem.toItem(config, string, replace);
            return this;
        }

        public Builder slot(int n) {
            this.slot = n;
            return this;
        }

        public Builder row(int n) {
            this.row = n;
            return this;
        }

        public Builder rawSlot(int n) {
            this.row = n / 9 + 1;
            this.slot = -9 * this.row + 10 + n;
            return this;
        }

        public Builder grid(int n, int n2) {
            this.slot = n;
            this.row = n2;
            return this;
        }

        public Builder onClick(ClickAction clickAction) {
            this.clickAction = clickAction;
            return this;
        }

        public MenuItem build() {
            return new MenuItem(this.itemStack, this.row, this.slot, this.clickAction);
        }

        public void buildTo(Menu menu) {
            menu.item(this.build());
        }
    }
}

