/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.storage;

import com.google.common.collect.Maps;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import me.hyfe.simplespigot.plugin.SimplePlugin;
import me.hyfe.simplespigot.storage.Backend;
import me.hyfe.simplespigot.storage.backends.FlatBackend;
import me.hyfe.simplespigot.storage.backends.MongoBackend;
import me.hyfe.simplespigot.storage.backends.mysql.MySqlBackend;

public class BackendFactory {
    private final SimplePlugin plugin;
    private Map<String, BiFunction<UnaryOperator<Path>, String, Backend>> backendMap = Maps.newConcurrentMap();

    public BackendFactory(SimplePlugin simplePlugin) {
        this.plugin = simplePlugin;
        this.addBackend("mysql", (String string) -> new MySqlBackend(this.plugin, (String)string)).addBackend("mongodb", (String string) -> new MongoBackend());
    }

    public Backend create(String string, UnaryOperator<Path> unaryOperator, String string2) {
        for (Map.Entry<String, BiFunction<UnaryOperator<Path>, String, Backend>> entry : this.backendMap.entrySet()) {
            if (!entry.getKey().toLowerCase().equalsIgnoreCase(string)) continue;
            return entry.getValue().apply(unaryOperator, string2);
        }
        return new FlatBackend(((Path)unaryOperator.apply(this.plugin.getDataFolder().toPath().toAbsolutePath())).resolve(string2));
    }

    public Backend create(String string, String string2) {
        return this.create(string, path -> path, string2);
    }

    public Backend create(String string, UnaryOperator<Path> unaryOperator) {
        return this.create(string, unaryOperator, "");
    }

    public BackendFactory addBackend(String string, BiFunction<UnaryOperator<Path>, String, Backend> biFunction) {
        this.backendMap.put(string, biFunction);
        return this;
    }

    public BackendFactory addBackend(String string2, Function<String, Backend> function) {
        this.addBackend(string2, (UnaryOperator<Path> unaryOperator, String string) -> (Backend)function.apply((String)string));
        return this;
    }

    public BackendFactory addBackendAsPath(String string2, Function<UnaryOperator<Path>, Backend> function) {
        this.addBackend(string2, (UnaryOperator<Path> unaryOperator, String string) -> (Backend)function.apply((UnaryOperator<Path>)unaryOperator));
        return this;
    }
}

