/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.storage.backends;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import me.hyfe.simplespigot.storage.Backend;

public class FlatBackend
implements Backend {
    private final Path path;
    private final Path subPath;

    public FlatBackend(Path path) {
        this.subPath = path;
        this.path = this.createPath(path);
    }

    @Override
    public JsonObject load(String string) {
        Path path = this.path.resolve(string + ".json");
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        FileReader fileReader = new FileReader(path.toFile());
        JsonParser jsonParser = new JsonParser();
        return jsonParser.parse((Reader)fileReader).getAsJsonObject();
    }

    @Override
    public void save(String string, JsonObject jsonObject) {
        if (Files.exists(this.path, new LinkOption[0])) {
            Path path = this.path.resolve(string + ".json");
            Gson gson = new GsonBuilder().create();
            BufferedWriter bufferedWriter = Files.newBufferedWriter(path, new OpenOption[0]);
            gson.toJson((JsonElement)jsonObject, (Appendable)bufferedWriter);
            ((Writer)bufferedWriter).close();
        }
    }

    @Override
    public Set<JsonObject> loadAll() {
        return Files.walk(this.path, new FileVisitOption[0]).map(Path::toString).filter(string -> string.endsWith(".json")).map(string -> string.replace(".json", "")).map(this::load).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public void close() {
    }

    private Path createPath(Path path) {
        if (Files.exists(path, new LinkOption[0]) && (Files.isDirectory(path, new LinkOption[0]) || Files.isSymbolicLink(path))) {
            return path;
        }
        path.toFile().mkdirs();
        return path;
    }
}

