/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.storage.backends.mysql;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.UnaryOperator;
import me.hyfe.simplespigot.plugin.SimplePlugin;
import me.hyfe.simplespigot.storage.Backend;
import me.hyfe.simplespigot.storage.StorageSettings;
import me.hyfe.simplespigot.storage.backends.mysql.MySqlConnectionFactory;

public class MySqlBackend
implements Backend {
    private static final String CREATE_TABLE = "CREATE TABLE IF NOT EXISTS `%where%` ( id VARCHAR(36) NOT NULL, json MEDIUMBLOB NOT NULL, PRIMARY KEY (id) )";
    private static final String DELETE = "DELETE FROM `%where%` WHERE id=?";
    private static final String INSERT = "INSERT INTO `%where%` (id, json) VALUES(?, ?)";
    private static final String SELECT = "SELECT id, json FROM `%where%` WHERE id=?";
    private static final String SELECT_ALL = "SELECT * FROM `%where%`";
    private final StorageSettings storageSettings;
    private final MySqlConnectionFactory connectionFactory;
    private final UnaryOperator<String> processor;

    public MySqlBackend(SimplePlugin simplePlugin, String string) {
        this.storageSettings = simplePlugin.getStorageSettings();
        this.connectionFactory = new MySqlConnectionFactory(this.storageSettings);
        this.processor = string2 -> string2.replace("%where%", this.storageSettings.getPrefix().concat(string));
        this.createTable();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public JsonObject load(String string) {
        try (Connection connection = this.connectionFactory.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement((String)this.processor.apply(SELECT));){
            preparedStatement.setString(1, string);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (!resultSet.next()) return null;
                JsonObject jsonObject = new JsonParser().parse(resultSet.getString("json")).getAsJsonObject();
                return jsonObject;
            }
        }
    }

    @Override
    public void save(String string, JsonObject jsonObject) {
        PreparedStatement preparedStatement;
        try (Connection connection = this.connectionFactory.getConnection();){
            preparedStatement = connection.prepareStatement((String)this.processor.apply(DELETE));
            try {
                preparedStatement.setString(1, string);
                preparedStatement.execute();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        connection = this.connectionFactory.getConnection();
        try {
            preparedStatement = connection.prepareStatement((String)this.processor.apply(INSERT));
            try {
                preparedStatement.setString(1, string);
                preparedStatement.setString(2, new Gson().toJson((JsonElement)jsonObject));
                preparedStatement.execute();
            }
            finally {
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    @Override
    public Set<JsonObject> loadAll() {
        HashSet hashSet = Sets.newHashSet();
        try (Connection connection = this.connectionFactory.getConnection();
             PreparedStatement preparedStatement = connection.prepareStatement((String)this.processor.apply(SELECT_ALL));
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                hashSet.add(new JsonParser().parse(resultSet.getString("json")).getAsJsonObject());
            }
        }
        return hashSet;
    }

    @Override
    public void close() {
        this.connectionFactory.close();
    }

    private void createTable() {
        try (Connection connection = this.connectionFactory.getConnection();){
            connection.createStatement().execute((String)this.processor.apply(CREATE_TABLE));
        }
    }
}

