/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.storage.backends.mysql;

import io.github.battlepass.hikari.HikariConfig;
import io.github.battlepass.hikari.HikariDataSource;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.function.Function;
import me.hyfe.simplespigot.storage.StorageSettings;
import org.bukkit.Bukkit;

public class MySqlConnectionFactory {
    private final StorageSettings storageSettings;
    private final HikariConfig config;
    private HikariDataSource dataSource;

    public MySqlConnectionFactory(StorageSettings storageSettings) {
        this.storageSettings = storageSettings;
        this.config = new HikariConfig();
        try {
            this.dataSource = new HikariDataSource(this.configure(this.config));
        }
        catch (Exception exception) {
            Bukkit.getLogger().severe("Could not setup mysql, please check your credentials.");
            exception.printStackTrace();
        }
        if (this.getConnection() != null) {
            Bukkit.getLogger().info("Successfully connected to MySQL.");
        }
    }

    public Connection getConnection() {
        if (this.dataSource == null) {
            throw new SQLException("Unable to get a connection from the pool.");
        }
        Connection connection = this.dataSource.getConnection();
        if (connection == null) {
            throw new SQLException("Unable to get a connection from the pool.");
        }
        return connection;
    }

    public void close() {
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    private HikariConfig configure(HikariConfig hikariConfig) {
        try {
            Class.forName("com.mysql.cj.jdbc.MysqlDataSource");
            hikariConfig.setDataSourceClassName("com.mysql.cj.jdbc.MysqlDataSource");
        }
        catch (Exception exception) {
            hikariConfig.setDataSourceClassName("com.mysql.jdbc.jdbc2.optional.MysqlDataSource");
        }
        this.config.setUsername(this.storageSettings.getUsername());
        this.config.setPassword(this.storageSettings.getPassword());
        this.config.setPoolName(this.storageSettings.getPrefix().concat("hikari"));
        this.config.setMaximumPoolSize(this.storageSettings.getMaximumPoolSize());
        this.config.setMinimumIdle(this.storageSettings.getMinimumIdle());
        this.config.setMaxLifetime(this.storageSettings.getMaximumLifetime());
        this.config.setConnectionTimeout(this.storageSettings.getConnectionTimeout());
        this.addProperty("characterEncoding", "utf8");
        this.addProperty("serverName", StorageSettings::getHost);
        this.addProperty("port", StorageSettings::getPort);
        this.addProperty("databaseName", StorageSettings::getDatabase);
        for (Map.Entry<String, String> entry : this.storageSettings.getProperties().entrySet()) {
            this.addProperty(entry.getKey(), entry.getValue());
        }
        return hikariConfig;
    }

    private void addProperty(String string, Function<StorageSettings, Object> function) {
        this.config.addDataSourceProperty(string, function.apply(this.storageSettings));
    }

    private void addProperty(String string, Object object) {
        this.config.addDataSourceProperty(string, object);
    }
}

