/*
 * Decompiled with CFR 0.152.
 */
package me.hyfe.simplespigot.storage.storage;

import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import me.hyfe.simplespigot.plugin.SimplePlugin;
import me.hyfe.simplespigot.storage.Backend;
import me.hyfe.simplespigot.storage.BackendFactory;
import me.hyfe.simplespigot.storage.adapter.Adapter;
import me.hyfe.simplespigot.storage.storage.load.Deserializer;
import me.hyfe.simplespigot.storage.storage.load.Serializer;

public abstract class Storage<T> {
    private Backend backend;
    private GsonBuilder gsonBuilder;
    private Gson gson;

    public Storage(SimplePlugin simplePlugin, Function<BackendFactory, Backend> function) {
        this.backend = function.apply(new BackendFactory(simplePlugin));
        this.gsonBuilder = new GsonBuilder();
        this.gson = new Gson();
    }

    public Storage(Backend backend) {
        this.backend = backend;
    }

    public abstract Serializer<T> serializer();

    public abstract Deserializer<T> deserializer();

    public void addAdapter(Class<?> clazz, Adapter<?> adapter) {
        this.gsonBuilder.registerTypeAdapter(clazz, adapter);
    }

    public void saveChanges() {
        this.gson = this.gsonBuilder.create();
    }

    public T load(String string) {
        JsonObject jsonObject = this.backend.load(string);
        return jsonObject == null ? null : (T)this.deserializer().apply(jsonObject, this.gson);
    }

    public T save(String string, T t) {
        this.backend.save(string, this.serializer().apply(t, new JsonObject(), this.gson));
        return t;
    }

    public Set<T> loadAll() {
        HashSet hashSet = Sets.newHashSet();
        for (JsonObject jsonObject : this.backend.loadAll()) {
            hashSet.add(this.deserializer().apply(jsonObject, this.gson));
        }
        return hashSet;
    }

    public void closeBack() {
        this.backend.close();
    }
}

